/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.event;

import java.util.*;

/**
 * Class implementing an event list iterator used within the event list
 * implementation.
 *
 * @author Markus Breitenfelder
 * @created 23. Januar 2003
 */
public class EventListIterator implements IEventListIterator {

  private ListIterator m_it = null;

  /**
   * Construct instance based on real ListIterator at heart.
   *
   * @param it real ListIterator at heart
   */
  public EventListIterator(ListIterator it) {
    m_it = it;
  }

  /**
   * Check for next event in list.
   *
   * @return true if another event is in list
   */
  public boolean hasNext() {
    return m_it.hasNext();
  }

  /**
   * Get next event from list.
   *
   * @return next event from list
   */
  public IEvent next() {
    return (IEvent)m_it.next();
  }
}
