/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.enum;

/**
 * Abstract class extending a type-safe enumeration by a description. You have
 * to extend this class, add your public final static enumeration members and
 * implement an appropriate private constructor: <pre>
 * public class Status extends EnumWithDescription
 * {
 *     public final static Status SUCCESS = new Status( 1, "Success" );
 *     public final static Status FAILURE = new Status( 2, "Failure" );
 *
 *     private A( final int id, final String description )
 *     {
 *         super( id, description );
 *     }
 * }
 * </pre>
 *
 * @created 20. Januar 2003
 */
public abstract class EnumWithDescription extends Enum {
  // This enum instance description
  private final String description;

  /**
   * Construct instance of an enumeration with description.
   *
   * @param id enumeration id
   * @param description enumeration description
   * @param ignoreDuplicateRegistration when true, don't throw
   *      IllegalArgumentException exception when the id is already in use
   */
  protected EnumWithDescription(final int id, final String description, final boolean ignoreDuplicateRegistration) {
    // Call super constructor
    super(id, ignoreDuplicateRegistration);

    // Store description
    this.description = description;
  }

  /**
   * Get description of the enumeration instance.
   *
   * @return description of the enumeration instance
   */
  public String getDescription() {
    // Return description
    return description;
  }

  /**
   * Get descriptive text for this enumeration instance.
   *
   * @return descriptive text for this enumeration instance
   */
  public String toString() {
    // Return description
    return description;
  }
}
