/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.context;

/**
 * Interface describing a stack of context objects. This stack shall be used by
 * context factories to store multiple stacked contexts within each thread. When
 * no (more) context is available, a ContextUnavailableException is thrown.
 *
 * @created 20. Januar 2003
 */
public interface IContextStack {
  /**
   * Checks if there is at least one actual context stacked.
   *
   * @return flag indicating whether there is at least one actual context
   *      stacked
   */
  public boolean isAvailable();

  /**
   * Get the number of context entries in the stack of contexts.
   *
   * @return number of context entries in the stack of contexts
   */
  public int size();

  /**
   * Get actual context from stack of contexts.
   *
   * @return actual context on the context stack
   * @exception ContextUnavailableException when no (more) context is available
   *      on the context stack
   */
  public Object getTypeUnsafeContext()
    throws ContextUnavailableException;

  /**
   * Get actual context from stack of contexts. Return null if none is availble
   * and don't throw a ContextUnavailableException.
   *
   * @return actual context on the context stack
   */
  public Object getTypeUnsafeContextOrNullIfUnavailable();

  /**
   * Replace actual context with new one in stack of contexts. If no context is
   * stored, this one will be added.
   *
   * @param context new actual context replacing the old one on the stack
   */
  public void setTypeUnsafeContext(Object context);

  /**
   * Get and remove actual context from the stack of contexts.
   *
   * @return last actual context on the context stack
   * @exception ContextUnavailableException when no (more) context is available
   *      on the context stack
   */
  public Object popTypeUnsafeContext()
    throws ContextUnavailableException;

  /**
   * Add new context to the top of the stack of contexts.
   *
   * @param context new actual context
   */
  public void pushTypeUnsafeContext(Object context);
}
