/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.context;

/**
 * Error raised when the context factory identified by it's class (name) is
 * already or isn't registered with the context factory registry.
 *
 * @created 20. Januar 2003
 */
public class ContextFactoryRegistrationError extends Error {
  /**
   * Construct instance of ContextUnavailableException with the hint, that the
   * context factory is already registered.
   *
   * @param contextFactory context factory
   */
  public ContextFactoryRegistrationError(IContextFactory contextFactory) {
    super(
      "Context factory "
       + contextFactory
       + " loaded by " + contextFactory.getClass().getClassLoader() + " was already registered using id "
       + contextFactory.getClass().getName());
  }

  /**
   * Construct instance of ContextUnavailableException with the hint, that the
   * context factory isn't registered.
   *
   * @param contextFactoryClass class of context factory
   */
  public ContextFactoryRegistrationError(Class contextFactoryClass) {
    super(
      "Context factory "
       + contextFactoryClass.getName()
       + " is not registered!");
  }
}
