/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.context;

/**
 * Abstract context factory base class for context factory interface
 * implementations being dependent on other context factory implementations. No
 * writing optional operations are supported in dependent context factories.
 *
 * @created 20. Januar 2003
 * @see IContextFactory
 */
public abstract class AbstractDependentContextFactory
   extends AbstractContextFactory {
  /**
   * Construct object of class AbstractDependentContextFactory.
   *
   * @exception ContextFactoryRegistrationError when the context factory is
   *      already registered with the context factory registry
   */
  protected AbstractDependentContextFactory()
    throws ContextFactoryRegistrationError {
    super();
  }

  /**
   * Replace actual context with new one in stack of contexts. If no context is
   * stored, this one will be added.
   *
   * @param context new actual context replacing the old one on the stack
   * @exception UnsupportedOperationException when the context factory isn't
   *      supporting this writing optional operation
   */
  public void setTypeUnsafeContext(Object context)
    throws UnsupportedOperationException {
    throw new UnsupportedOperationException("Dependent context factory can't implement modifying context factory methods!");
  }

  /**
   * Remove actual context including all other stacked contexts completely
   * (optional operation).
   *
   * @exception UnsupportedOperationException when the context factory isn't
   *      supporting this writing optional operation
   */
  public void removeTypeUnsafeContext()
    throws UnsupportedOperationException {
    throw new UnsupportedOperationException("Dependent context factory can't implement modifying context factory methods!");
  }

  /**
   * Get and remove actual context from the stack of contexts.
   *
   * @return last actual context on the context stack
   * @exception ContextUnavailableException when no (more) context is available
   *      on the context stack
   * @exception UnsupportedOperationException when the context factory isn't
   *      supporting this writing optional operation
   */
  public Object popTypeUnsafeContext()
    throws ContextUnavailableException,
    UnsupportedOperationException {
    throw new UnsupportedOperationException("Dependent context factory can't implement modifying context factory methods!");
  }

  /**
   * Add new context to the top of the stack of contexts.
   *
   * @param context new actual context
   * @exception UnsupportedOperationException when the context factory isn't
   *      supporting this writing optional operation
   */
  public void pushTypeUnsafeContext(Object context)
    throws UnsupportedOperationException {
    throw new UnsupportedOperationException("Dependent context factory can't implement modifying context factory methods!");
  }
}
