/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.context;

/**
 * Abstract context factory base class for context factory interface
 * implementations.
 *
 * @created 20. Januar 2003
 * @see IContextFactory
 */
public abstract class AbstractContextFactory implements IContextFactory {
  /**
   * Construct object of class AbstractContextFactory and register thereby the
   * newly contructed context factory with the context factory registry.
   *
   * @exception ContextFactoryRegistrationError when the context factory is
   *      already registered with the context factory registry
   */
  protected AbstractContextFactory()
    throws ContextFactoryRegistrationError {
    ContextFactoryRegistry.registerContextFactory(this);
  }
}
