/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepositoryModelClass.java#2 $
 */
package com.sap.tc.webdynpro.repository.api;

import java.util.Locale;

import com.sap.tc.cmi.model.ICMIGenericModelClass;

/**
 * The API to the generic repository object class that represents repository
 * content at runtime time. 
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepositoryModelClass.java#2 $
 */
public interface IWDRepositoryModelClass extends ICMIGenericModelClass {

  /**
   * Returns the name of the repository object.
   * @return the name of the repository object
   */
  public String getName();

  /**
   * Returns the parent of this object.
   * @return the parent of this object or null, if the object has no parent
   */
  public IWDRepositoryModelClass getParent();

  /**
   * Returns the personalization repository object for this repository object.
   * Throws an exception if no personalization repository object is available.
   * @return the personalization repository object for this repository object
   */
  public IWDRepositoryModelClass getPersonalizationObject();

  /**
   * Returns the repository root of this repository object.
   * @return the repository root of this repository object
   * 
   * @deprecated To improve consistency across the Web Dynpro API, this method 
   *   has been renamed to {@link #getRepositoryModel()}. The method with the 
   *   old name has been kept for backward compatiblity, but may be withdrawn 
   *   with the first new NetWeaver release in 2006.
   */
  public IWDRepositoryModel getRepositoryRoot();
  
  /**
   * Returns the repository model of this repository object.
   * @return the repository model of this repository object
   */
  public IWDRepositoryModel getRepositoryModel();  

  /**
   * Creates a new child object for the given relation.
   * Preconditions:<br>
   *  rolename is not empty<br>
   *  name is not empty<br>
   *  name must only contain a..zA..Z0..9._- symbols<br>
   *  object with the given name must not exist in the given role<br>
   *  the relation must be an aggregation<br>
   * @param rolename name of the relation role the new child will belong to
   * @param name name of the child object
   * @return the newly created child object
   * @throws RepositoryRuntimeException if <code>name</code> is the name of an object 
   * that was deleted in the current variant, in one of its predecessor variants or in 
   * the personalization layer before 
   */
  public IWDRepositoryModelClass createRelatedModelObject(String rolename, String name);

  /**
   * Creates a new child object for the given relation.
   * The provided modelClassInfo must belong to a modelClass which is a sub-class
   * of the aggregated class.
   * Preconditions:<br>
   *  rolename is not empty<br>
   *  name is not empty<br>
   *  name must only contain a..zA..Z0..9._- symbols<br> 
   *  object with the given name must not exist in the given role<br>
   *  the relation must be an aggregation<br>
   * @param rolename name of the relation role the new child will belong to
   * @param name name of the child object
   * @param modelClassInfo the class description to use when creating the object
   * @return the newly created child object
   * @throws RepositoryRuntimeException if <code>name</code> is the name of an object 
   * that was deleted in the current variant, in one of its predecessor variants or in 
   * the personalization layer before    
   */
  public IWDRepositoryModelClass createRelatedModelObject(
    String rolename,
    String name,
    IWDRepositoryModelClassInfo modelClassInfo);

  /**
   * Deletes the given child object from the given relation.
   * Preconditions:<br>
   *  rolename is not empty<br>
   *  the role be a valid target role for this repository model class<br>
   *  o != null
   * @param rolename name of the relation role the child belongs to
   * @param o the child object to be deleted
   * @return true, iff the child belonged to the given relation role and was
   *         deleted
   */
  public boolean deleteRelatedModelObject(String rolename, IWDRepositoryModelClass o);

  /**
   * Returns true, iff the current object is a versionable model object.
   * @returns true, iff the current object is a versionable model object
   */
  public boolean isVersionableModelObject();

  /**
   * Returns the value of an attribute for the specified locale.
   * The search algorithm is as follows (the first found value is used):<br>
   * Specified locale in current layer.<br>
   * Specified locale without country in current layer.<br>
   * Specified locale in previous layers.<br>
   * Specified locale without country in previous layers.<br>
   * Master locale in current layer.<br>
   * Master locale without country in current layer.<br>
   * Master locale in previous layers.<br>
   * Master locale without country in previous layers.<br>
   * Continue search in the same way for all predecessing variants.<br>
   * Precondition: <code>name</code> denotes an attribute that is translatable, i.e. 
   * <code>((RepositoryObjectAttributeInfo) associatedModelClassInfo.getPropertyInfo(name)).isTranslatable() 
   * == true</code>   
   * 
   * @param name the attribute's name
   * @param locale the locale to be used; if null, the default locale of the
   * repository is used
   * @return the value of the attribute with name supplied as input parameter; 
   * if the attribute couldn't be found, <code>null</code> is returned
   */
  public String getAttributeValue(String name, Locale locale);

  /**
   * Sets the attribute value.
   * Precondition: <code>name</code> denotes an attribute that is translatable, i.e. 
   * <code>((RepositoryObjectAttributeInfo) associatedModelClassInfo.getPropertyInfo(name)).isTranslatable() 
   * == true</code>   
   * 
   * @param name name of the attribute
   * @param value value of the attribute
   * @param locale the locale the specified value belongs to   
   */
  public void setAttributeValue(String name, String value, Locale locale);
}
