/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepositoryModel.java#2 $
 */
package com.sap.tc.webdynpro.repository.api;

import java.util.Iterator;

import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;

/**
 * API of a runtime repository model. 
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepositoryModel.java#2 $
 */
public interface IWDRepositoryModel extends ICMIModel {
  
  /**
   * Creates a new Repository Model Object with the given name.
   *
   * Preconditions:  
   *  name is not empty
   *  modelClass != null
   *  modelClass must be a versionable Object
   *  modelClass must belong to the associatedModelInfo()
   *  an object with the given name and modelClass must not exist
   * @param name name of the new model object
   * @param modelClassInfo metadata of the type of the model object to be
   * created
   * @return the newly created model object
  */
  public IWDRepositoryModelClass createModelObject(String name, IWDRepositoryModelClassInfo modelClass);
  
  /**
   * This (optional) method of the Common Model Interface (CMI) is not supported 
   * by the Runtime Repository model and therefore must not be used. See 
   * {@link #createModelObject(String, IWDRepositoryModelClassInfo)} for an alternative.
   * 
   * @deprecated Use {@link #createModelObject(String, IWDRepositoryModelClassInfo)} instead.  
   *   Deprecation of this method only serves as a hint that the method is not supported. 
   */
  public ICMIModelClass createModelObject(Class modelClass);
  
  /**
   * This (optional) method of the Common Model Interface (CMI) is not supported 
   * by the Runtime Repository model and therefore must not be used. See 
   * {@link #createModelObject(String, IWDRepositoryModelClassInfo)} for an alternative.
   * 
   * @deprecated Use {@link #createModelObject(String, IWDRepositoryModelClassInfo)} instead.  
   *   Deprecation of this method only serves as a hint that the method is not supported. 
   */
  public ICMIModelClass createModelObject(String modelClassName);

  /**
   * Returns the specified model object or null if it does not exist.
   * Preconditions:  
   *  name is not empty
   *  modelClass != null
   *  modelClass must be a versionable Object
   *  modelClass must belong to the associatedModelInfo()
   *  name must only contain a..zA..Z0..9._- symbols
   * @param name name of the object to return
   * @param modelClass metadata of the type of the object to return
   * @return the requested object or null if it does not exist
   */
  public IWDRepositoryModelClass getModelObject(String name, IWDRepositoryModelClassInfo modelClass);

  /**
   * Deletes the given Repository Model Object.
   *
   * Preconditions  
   *  modelObject != null
   * 
   * @param modelObject the model object to be deleted
  */
  public void deleteModelObject(IWDRepositoryModelClass modelObject);
  
  /**
   * Returns the repository this repository model is assigned to.
   * @return the repository this repository model is assigned to
   */
  public IWDRepository getRepository();

  /**
   * Returns an iterator of model object names.
   * Objects must be<br>
   *  * of the type specified by <code>modelClassInfo</code><br>
   *  * part of the variant or one of its predecessors of the repository<br>
   *  * part of the deployable object currently assigned to the repository<br>
   * to be included in the iterator.
   * <code>modelClassInfo</code> must be part of the model.
   * @param modelClassInfo metadata of the type of the model objects to iterate
   * @return the iterator providing the names of the found objects
   */
  public Iterator iterateVersionableModelObjects(IWDRepositoryModelClassInfo modelClassInfo);
  
  /**
   * Returns an iterator of model object names.
   * Objects must be<br>
   *  * of the type specified by <code>modelClassInfo</code><br>
   *  * part of the variant or one of its predecessors of the repository<br>
   * to be included in the iterator.
   * <code>modelClassInfo</code> must be part of the model.
   * @param modelClassInfo metadata of the type of the model objects to iterate
   * @return the iterator providing the names of the found objects
   */
  public Iterator iterateAllVersionableModelObjects(IWDRepositoryModelClassInfo modelClassInfo);
}
