/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepository.java#1 $
 */
package com.sap.tc.webdynpro.repository.api;

import java.util.Locale;

/**
 * API of a Runtime Repository
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepository.java#1 $
 */
public interface IWDRepository {
  
  /**
   * Returns true in case the repository runs in maintenance mode. If it runs 
   * in runtime mode, false is returned.
   * 
   * @return true, iff the repository runs in maintenance mode
   */
  public boolean isMaintaining();
  
  /** 
   * Return is the repository model specified by the class supplied as 
   * input parameter. 
   * 
   * @param repositoryModelClass the concrete repository model class; this class 
   * must have been created by the configuration model editor
   * @return the repository model
   */
  public IWDRepositoryModel getRepositoryModel(Class repositoryModelClass);
  
  /**
   * Closes the currently opened repository.
   * This should be called to free ressources when the repository is not needed
   * any longer.
   */
  public void close();
  
  /**
   * Writes all changed repository objects to the persistent storage.
   * Precondition: <code>isMaintaining()==true</code>     
   */
  public void commitChanges(); 
    
  /**
   * Returns the associated repository for personalization.
   * Returns null if repository is not opened in runtime mode.
   * @return the associated repository for personalization
   */
  public IWDRepository getPersonalizationRepository();
  
  /**
   * Returns the default locale this repository instance was opened for.  
   *
   * @return the default locale this repository instance was opened for
   */
  public Locale getDefaultLocale();      
}
