@echo off
rem start SAPinst GUI

setlocal

echo When you encounter problems where the GUI doesn't redraw correctly when being
echo viewed over a remote access application like pcAnywhere then restart with the
echo parameter FORCE_REDRAW:
echo usage: startinstgui.bat FORCE_REDRAW
echo.

set SYSPROPS=
IF "%1" == "FORCE_REDRAW" set SYSPROPS=-Dsun.java2d.noddraw=true && SHIFT /1

rem
rem determine cwd (current working directory)
rem
set cwd=%~dp0

set GUI_PATH=%cwd%\sapinstgui.exe

rem
rem normalize SAPINST_JRE_HOME if available
rem
if defined SAPINST_JRE_HOME (
  pushd %SAPINST_JRE_HOME%
  for /f "tokens=*" %%a in ('cd') do set SAPINST_JRE_HOME=%%a
  popd
)

rem
rem test presence of sapinstgui executable
rem
if exist "%GUI_PATH%" (
  echo Starting SAPinst GUI from self-extracting executable with build-in Java Runtime
  echo   Running %GUI_PATH%
  "%GUI_PATH%" %*
  goto :EOF
) else (
  echo Starting SAPinst GUI with local Java Runtime

  rem
  rem check whether java runtime is available by searching
  rem  1) in %cwd%\jre\bin
  rem  2) in %SAPINST_JRE_HOME%\bin
  rem  3) in %JAVA_HOME%\bin
  rem  4) in the %PATH% environment variable
  rem
  if exist "%cwd%\jre\bin\java.exe" (
    set JRE_PATH=%cwd%\jre\bin\java.exe
    echo   Java Runtime found in local subdirectory jre\
    goto :GO
  ) else (
    if exist "%SAPINST_JRE_HOME%\bin\java.exe" (
      set JRE_PATH=%SAPINST_JRE_HOME%\bin\java.exe
      echo   Java Runtime found in SAPINST_JRE_HOME environment variable
      goto :GO
  ) else (
    if exist "%JAVA_HOME%\bin\java.exe" (
      set JRE_PATH=%JAVA_HOME%\bin\java.exe
      echo   Java Runtime found in JAVA_HOME environment variable
      goto :GO
    ) else (
      goto SEARCH_PATH
    )
  )

:SEARCH_PATH
  rem
  rem search JRE in PATH environment variable
  rem
  change user /install >NUL: 2>&1
  for %%i in (java.exe) do set JRE_DIR=%%~dp$PATH:i
  if "%JRE_DIR%" == "" (
    echo ERROR: No Java Runtime found.
    echo        SAPinst GUI requires Java 1.4.1 or later.
    echo        Solution: Set the environment variable SAPINST_JRE_HOME to the existing
    echo                  Java Runtime or install a new one.
    pause
    goto :EOF
  )
  rem normalize JRE_DIR
  pushd %JRE_DIR%
  for /f "tokens=*" %%a in ('cd') do set JRE_DIR=%%a
  popd
  set JRE_PATH=%JRE_DIR%\java.exe
  echo   Java Runtime found in PATH environment variable
  goto :GO

:GO
  rem
  rem start SAPinstGUI with local java runtime
  rem
  echo   Java path: %JRE_PATH%
  "%JRE_PATH%" -cp "%cwd%\jar\instgui.jar;%cwd%\jar\inqmyxml.jar" %SYSPROPS% com.sap.ins.gui.Main %1 %2 %3 %4 %5 %6 %7 %8 %9
  goto :EOF
  )
)

endlocal
