WHENEVER SQLERROR EXIT SQL.SQLCODE
connect / as sysdba
set feedback off
spool sapdba_additional.log
set serverout on
set termout on
--set echo on;
/*----------------------------------------------------------------------------------------------------------*/
/*  sapdba_additional.sql creates objects needed by sapdba for non R/3 databases.                           */
/*  @(#) $Id: //bc/640-2/src/ins/SAPINST/impl/xml_internal_j2ee/components/shared/jslib/ora/tpls/SAPDBA_ADDITIONAL.SQL#1 $  */
/*                                                                                                          */
/*  usage:                                                                                                  */
/*   UNIX: sqlplus "/ as sysdba" @sapdba_additional.sql SCHEMAOWNER UNIX X                                  */
/*   NT:   sqlplus "/ as sysdba" @sapdba_additional.sql SCHEMAOWNER NT   OSDBAUSER                          */
/*                                                                                                          */
/*  The OS user who runs this script has to be member of the dba group.                                     */
/*  On NT OSDBAUSER must be specified as DOMAIN\USERNAME resp.                                              */
/*  COMPUTERNAME\USERNAME depending on whether you are using a domain or                                    */
/*  a local account.                                                                                        */
/*  On Unix x is a dummy paramter and may e. g. be set to  X                                                */ 
/*----------------------------------------------------------------------------------------------------------*/



VARIABLE bONNT    number;
VARIABLE sPos number;
VARIABLE sSchemaUser varchar2(100);
VARIABLE sSapSid  varchar2(4);
VARIABLE sOPSDUserSidAdm varchar2(100);
VARIABLE sOPSDUserOraSid varchar2(100);
VARIABLE sPrefix varchar2(100);
VARIABLE sDbSid varchar2(4);
VARIABLE sSvcuser varchar2(100);
VARIABLE sDomain varchar2(100);
VARIABLE sUser varchar2(100);
VARIABLE sString varchar2(100);


WHENEVER OSERROR EXIT FAILURE


/* ---  initialization ---*/
/* SID, Oracle DB Version, Prefix, Domainname, number of sapuser tables */
begin
begin
  :sSchemaUser := upper('&&1');
  if length(:sSchemaUser) != 8 then
    RAISE_APPLICATION_ERROR(-20001,'Invalid SchemaUser, must be SAP<SCHEMAID>DB.');
  elsif upper(substr(:sSchemaUser,1,3)) != 'SAP' then 
    RAISE_APPLICATION_ERROR(-20002,'Invalid SchemaUser, must be started with "SAP".');
  elsif upper(substr(:sSchemaUser,7,2)) != 'DB' then 
    RAISE_APPLICATION_ERROR(-20003,'Invalid SchemaUser, must be ended with "DB".');
  end if;
  :sSapSid     := substr(:sSchemaUser,4,3);

/* select DBSID and PREFIX from database */
  select value into :sPrefix from v$parameter where name='os_authent_prefix';
  select name  into :sDbSid from v$database;
  :sPrefix := upper(:sPrefix);

/* set parameter for NT and UNIX and raise of invalid OS */
  if upper('&&2') = 'NT' then
    :bONNT := 1;
    :sDomain := upper('&&3');
    :sOPSDUserSidAdm := :sPrefix || :sDomain ;

    /* search for '\' in Computer\user or Domain\user */
    :sPos := instr(:sDomain,'\');
    if :sPos = 0 then
      dbms_output.put_line('Invalid Computer or Domain: must include a "\": '||:sDomain);
      RAISE_APPLICATION_ERROR(-20000,'Invalid Computer or Domain.');
    end if;
    :sString := substr(:sDomain,1,instr(:sDomain,'\'));
    :sSvcuser := :sPrefix || :sString || 'SAPSERVICE' || :sSapSid;
  elsif upper('&&2') = 'UNIX' then
    :bONNT := 0;
    :sOPSDUserSidAdm := :sPrefix || :sSapSid || 'ADM';
    :sOPSDUserOraSid := 'OPS$' || 'ORA' || :sDbSid;
  else
    RAISE_APPLICATION_ERROR(-20004,'Invalid OS, must be "NT" or "UNIX": ' || upper('&&2'));
  end if;
  EXCEPTION
    when others then
    RAISE;


end;
end;
/

set termout on
begin
begin
/* print out given parameter */
     dbms_output.put_line('using following Parameters: ');
     dbms_output.put_line('.');
     dbms_output.put_line('.  Schema User:                        '||:sSchemaUser);
     dbms_output.put_line('.  Parametervalue os_authent_prefix:   '||:sPrefix);
     dbms_output.put_line('.  OPS$SIDADM:                         '||:sOPSDUserSidAdm);
     dbms_output.put_line('.  SAP SID:                            '||:sSapSid);
     dbms_output.put_line('.  DB  SID:                            '||:sDbSid);
     if :bONNT = 1 then
       dbms_output.put_line('.  R/3 Service User:                   '||:sSvcuser);
       dbms_output.put_line('.  Computer or Domain:                 '||:sDomain);
     else
       dbms_output.put_line('.  OPS$ORASID:                         '||:sOPSDUserOraSid);
     end if; 
     dbms_output.put_line('.');
end;
end;
/

/*--- Drop old tables and create new ones including indexes and synonyms ---*/
begin
   DECLARE
	c number;
	r number;
	schema varchar2(60);
	tab varchar2(60);
begin
   begin
     schema := :sSchemaUser;
     tab := schema || '.SDBAH';
     c := dbms_sql.open_cursor;

/*--- Drop table SDBAH... ---*/
	   dbms_sql.parse(c, 'drop table ' || tab, DBMS_SQL.NATIVE);
	   r := dbms_sql.execute(c);
	   dbms_sql.close_cursor(c);
	EXCEPTION
	   when others then
	     if sqlcode = -942 then
 		     tab := 'dummy';
	     else
		     dbms_output.put_line('unable to drop table: '||tab);
		     RAISE;
	     end if;
   end;
   begin
     schema := :sSchemaUser;
     tab := schema || '.SDBAD';
     c := dbms_sql.open_cursor;

/*--- Drop table SDBAD... ---*/
	   dbms_sql.parse(c, 'drop table ' || tab , DBMS_SQL.NATIVE);
	   r := dbms_sql.execute(c);
	   dbms_sql.close_cursor(c);
	EXCEPTION
	   when others then
	     if sqlcode = -942 then
 		     tab := 'dummy';
	     else
		     dbms_output.put_line('unable to drop table: '||tab);
		     RAISE;
	     end if;
   end;

/*---   create table SDBAH... --- */
   begin
        schema := :sSchemaUser;
        tab := schema || '.SDBAH';
        c := dbms_sql.open_cursor;
        dbms_sql.parse(c, 'create table ' || tab 
                           || ' (BEG     VARCHAR2(42)   DEFAULT '' '' NOT NULL, '
                           ||   'FUNCT   VARCHAR2(9)    DEFAULT '' '' NOT NULL, '
                           ||   'SYSID   VARCHAR2(24)   DEFAULT '' '' NOT NULL, '
                           ||   'OBJ     VARCHAR2(48)   DEFAULT '' '' NOT NULL, '
                           ||   'RC      VARCHAR2(12)   DEFAULT '' '' NOT NULL, '
                           ||   'ENDE    VARCHAR2(42)   DEFAULT '' '' NOT NULL, '
                           ||   'ACTID   VARCHAR2(48)   DEFAULT '' '' NOT NULL, '
                           ||   'LINE    VARCHAR2(762)  DEFAULT '' '' NOT NULL)', 
                       DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
	      dbms_sql.close_cursor(c);
        EXCEPTION
           when others then
	           dbms_output.put_line('unable to create table: '||tab);
	           RAISE;
   end;

/*---   create table SDBAD... --- */
   begin
        schema := :sSchemaUser;
        tab := schema || '.SDBAD';
        c := dbms_sql.open_cursor;
        dbms_sql.parse(c, 'create table ' || tab 
                           || ' (BEG     VARCHAR2(42)   DEFAULT '' '' NOT NULL, '
                           ||   'FUNCT   VARCHAR2(9)    DEFAULT '' '' NOT NULL, '
                           ||   'SYSID   VARCHAR2(24)   DEFAULT '' '' NOT NULL, '
                           ||   'POS     VARCHAR2(12)   DEFAULT '' '' NOT NULL, '
                           ||   'LINE    VARCHAR2(762)  DEFAULT '' '' NOT NULL)', 
                       DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
	      dbms_sql.close_cursor(c);
        EXCEPTION
           when others then
	           dbms_output.put_line('unable to create table: '||tab);
	           RAISE;
   end;

/*---   create unique index for table SDBAH... --- */
   begin
        schema := :sSchemaUser;
        tab := schema || '.SDBAH';
        c := dbms_sql.open_cursor;
        dbms_sql.parse(c, 'CREATE UNIQUE INDEX ' || schema || '.SDBAH__0 ON ' || tab || ' (BEG, FUNCT, SYSID)', 
                       DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
	      dbms_sql.close_cursor(c);
        EXCEPTION
           when others then
	           dbms_output.put_line('unable to create unique index: '|| schema || '.SDBAH__0');
	           RAISE;
   end;

/*---   create unique index for table SDBAD... --- */
   begin
        schema := :sSchemaUser;
        tab := schema || '.SDBAD';
        c := dbms_sql.open_cursor;
        dbms_sql.parse(c, 'CREATE UNIQUE INDEX ' || schema || '.SDBAD__0 ON ' || tab || ' (BEG, FUNCT, SYSID, POS)', 
                       DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
	      dbms_sql.close_cursor(c);
        EXCEPTION
           when others then
	           dbms_output.put_line('unable to create unique index: '|| schema || '.SDBAD__0');
	           RAISE;
   end;

/*---   create synonym for table SDBAH... --- */
   begin
        schema := :sSchemaUser;
        tab := schema || '.SDBAH';
        c := dbms_sql.open_cursor;
        dbms_sql.parse(c, 'CREATE OR REPLACE PUBLIC SYNONYM SAP_SDBAH FOR ' || tab, 
                       DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
	      dbms_sql.close_cursor(c);
        EXCEPTION
           when others then
	           dbms_output.put_line('unable to create synonym: SAP_SDBAH'|| schema || '.SDBAH__0');
	           RAISE;
   end;

/*---   create synonym for table SDBAD... --- */
   begin
        schema := :sSchemaUser;
        tab := schema || '.SDBAD';
        c := dbms_sql.open_cursor;
        dbms_sql.parse(c, 'CREATE OR REPLACE PUBLIC SYNONYM SAP_SDBAD FOR ' || tab, 
                       DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
	      dbms_sql.close_cursor(c);
        EXCEPTION
           when others then
	           dbms_output.put_line('unable to create synonym: SAP_SDBAD');
	           RAISE;
   end;
end;
end;
/

/*--- Drop old users ---*/
begin
   DECLARE
	c number;
	r number;
	s varchar2(60);
begin
   begin
     s := :sOPSDUserSidAdm;
     c := dbms_sql.open_cursor;

/*--- Drop User OPS$... ---*/
	   dbms_sql.parse(c, 'Drop user "' || s || '"', DBMS_SQL.NATIVE);
	   r := dbms_sql.execute(c);
	   dbms_sql.close_cursor(c);
	EXCEPTION
	   when others then
	     if sqlcode = -1917 or sqlcode = -1918 or sqlcode = -1922 then
 		     s := 'dummy';
	     else
		     dbms_output.put_line('unable to delete user: '||s);
		     RAISE;
	     end if;
   end;

   begin
      if :bONNT = 0 then
/*--- Drop user OPS$orasid ---*/
        s := :sOPSDUserOraSid;
      else
/*--- Drop user OPS$ServiceUser ---*/
        s := :sSvcuser;
      end if;

      c := dbms_sql.open_cursor;

/*--- Drop User ... ---*/
	   dbms_sql.parse(c, 'Drop user "' || s || '"', DBMS_SQL.NATIVE);
	   r := dbms_sql.execute(c);
	   dbms_sql.close_cursor(c);
	EXCEPTION
	   when others then
	     if sqlcode = -1917 or sqlcode = -1918 or sqlcode = -1922 then
 		     s := 'dummy';
	     else
		     dbms_output.put_line('unable to delete user: '||s);
		     RAISE;
	     end if;
   end;


/*---   create user OPS$SIDADM --- */
   begin

      s := :sOPSDUserSidAdm;
      c := dbms_sql.open_cursor;

      dbms_sql.parse(c, 'Create user "' || s || '" identified externally temporary tablespace psaptemp', DBMS_SQL.NATIVE);
      r := dbms_sql.execute(c);
      dbms_sql.close_cursor(c);
    EXCEPTION
            when others then
		if sqlcode = -1920 then
	         dbms_output.put_line('user already exists: '||s);
                else
	         dbms_output.put_line('unable to create user: '||s);
	         RAISE;
                end if;
    end;

/*--- UNIX only: create user OPS$ORASID --- */
   begin
      if :bONNT = 0 then
        s := :sOPSDUserOraSid;
        c := dbms_sql.open_cursor;
        dbms_sql.parse(c, 'Create user "' || s || '" identified externally temporary tablespace psaptemp', DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
        dbms_sql.close_cursor(c);
      end if; 
    EXCEPTION
           when others then
		if sqlcode = -1920 then
    	         dbms_output.put_line('user already exists: '||s);
                else
 	         dbms_output.put_line('unable to create user: '||s);
	         RAISE;
                end if;
    end;

/*--- NT only: create SAP Service OPS$ user  --- */
   begin
      if :bONNT = 1 then
        s := :sSvcuser;
        c := dbms_sql.open_cursor;
        dbms_sql.parse(c, 'Create user "' || s || '" identified externally temporary tablespace psaptemp', DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
        dbms_sql.close_cursor(c);
       end if;
     EXCEPTION
            when others then
		if sqlcode = -1920 then
                  dbms_output.put_line('user already exists: '||s);
                else
                  dbms_output.put_line('unable to create user: '||s);
                  RAISE;
                end if;
     end;


/*---  Create SAPDBA role ---*/
   begin
	  c := dbms_sql.open_cursor;
	  dbms_sql.parse(c, 'create role sapdba', DBMS_SQL.NATIVE);
	  r := dbms_sql.execute(c);
	  dbms_sql.close_cursor(c);
     EXCEPTION
	when others then
	   if sqlcode = -1921 then
	     s := 'dummy';
           else
	     dbms_output.put_line('cannot create SAPDBA role: ');
	     RAISE;
	   end if;
   end;

/*---   UNIX only: grants for OPS$ORASID --- */
	begin
          if :bONNT = 0 then
		s := :sOPSDUserOraSid;
		c := dbms_sql.open_cursor;

		dbms_sql.parse(c, 'grant connect, resource to  "' || s || '"', DBMS_SQL.NATIVE);
		r := dbms_sql.execute(c);
		dbms_sql.close_cursor(c);
          end if;
	EXCEPTION
		when others then
 		  dbms_output.put_line('unable to grant connect, resource to: '||s);
		  RAISE;
	end;

/*---   grants for OPS$SIDADM --- */
   begin
     s := :sOPSDUserSidAdm;
     c := dbms_sql.open_cursor;
     dbms_sql.parse(c, 'grant connect, resource, sapdba to  "' || s || '"', DBMS_SQL.NATIVE);
     r := dbms_sql.execute(c);
     dbms_sql.close_cursor(c);
   EXCEPTION
          when others then
            dbms_output.put_line('unable to grant connect, resource, sapdba to: '||s);
	    RAISE;
   end;

/*---   NT only: grants for OPS$SAPSERVICEsid --- */
   begin
     if :bONNT = 1 then
        s := :sSvcuser;
        c := dbms_sql.open_cursor;

        dbms_sql.parse(c, 'grant connect, resource, sapdba to  "' || s || '"', DBMS_SQL.NATIVE);
        r := dbms_sql.execute(c);
        dbms_sql.close_cursor(c);
     end if;
     EXCEPTION
	when others then
 	   dbms_output.put_line('unable to grant connect, resource to: '||s);
	   RAISE;
   end;


end;
end;
/
EXIT SUCCESS
