connect / as sysdba
set feedback off
spool ora_create_dbusr.log
set serverout on
set termout on
--set echo on;

/*-------------------------------------------------------------------------------------------*/
/*  ora_create_dbusr.sql creates Oracle DB Users                                             */
/*  @(#) $Id: //bc/640-2/src/ins/SAPINST/impl/xml_internal_j2ee/components/shared/jslib/ora/tpls/ORA_CREATE_DBUSR.SQL#1 $ */
/*                                                                                           */
/*  usage:                                                                                   */
/*  sqlplus /NOLOG @ora_create_dbusr.sql SCHEMAOWNER PASSWD DEFAULT_TABLESPACE TEMP_TABLESPACE       */
/*                                                                                           */
/*-------------------------------------------------------------------------------------------*/

VARIABLE sSchema  varchar2(100);
VARIABLE tempTablespace  varchar2(100);
VARIABLE defTablespace  varchar2(100);
VARIABLE passwd  varchar2(100);
VARIABLE result number;

WHENEVER SQLERROR EXIT SQL.SQLCODE
WHENEVER OSERROR EXIT FAILURE

/* ---  initialization ---*/
begin
begin

  :sSchema := upper('&&1');
  :passwd := '&&2';
  :defTablespace := upper('&&3');
  :tempTablespace := upper('&&4');
  
end;
end;
/
set termout on

begin
begin
   dbms_output.put_line('using following Parameters: ');
   dbms_output.put_line('.');
   dbms_output.put_line('.  Database User (Schema):             '||:sSchema); 
   dbms_output.put_line('.  Password:                           **********'); 
   dbms_output.put_line('.  Default tablespace:                 '||:defTablespace);
   dbms_output.put_line('.  Temporary tablespace:               '||:tempTablespace);
   dbms_output.put_line('.');
end;
end;
/




begin
   DECLARE
    myCursor number;
    result number;
    schema varchar2(60);
    v_counter   integer;
    statement   varchar2(128);
begin


/*---   create user <schema-user> --- */
/* create <schema-user> identified by passwd                     */
/* if user already exists, check if it was given DBA role  */
/* if yes, revoke role DBA from schema-user                      */
  begin
      myCursor := dbms_sql.open_cursor;
      statement := 'create user "' || :sSchema || '" identified by "' || :passwd || '" temporary tablespace ' || :tempTablespace;
      dbms_sql.parse(myCursor, statement, DBMS_SQL.NATIVE);
      result := dbms_sql.execute(myCursor);
    exception
      when others then
        schema := :sSchema;
        select count(*) into v_counter from dba_role_privs where grantee = schema and granted_role ='DBA';
        if v_counter > 0 then
          statement := 'revoke dba from  ' || :sSchema;
          dbms_sql.parse(myCursor, statement, DBMS_SQL.NATIVE);
          result := dbms_sql.execute(myCursor);
        end if;
   end;
   
   
/* assign default tablespace to schema owner                      */
  begin
      statement := 'alter user ' || :sSchema || ' default tablespace '||:defTablespace;
      dbms_sql.parse(myCursor, statement, DBMS_SQL.NATIVE);
    result := dbms_sql.execute(myCursor);
    exception
      when others then
        dbms_output.put_line('unable to assign default tablespace to user: '||:sSchema);
        RAISE;
  end;


/* assign temporary tablespace to schema owner                    */
  begin
      statement := 'alter user ' || :sSchema || ' temporary tablespace ' || :tempTablespace;
      dbms_sql.parse(myCursor, statement, DBMS_SQL.NATIVE);
      result := dbms_sql.execute(myCursor);
    exception
      when others then
        dbms_output.put_line('unable to assign temporary tablespace ' || :tempTablespace || ' to user: '|| :sSchema);
        RAISE;
  end;



/* grant privileges to schema owner                               */
  statement := 'grant connect, resource, select_catalog_role, unlimited tablespace to ' || :sSchema;
  dbms_sql.parse(myCursor, statement, DBMS_SQL.NATIVE);
  result := dbms_sql.execute(myCursor);



end;
end;
/
EXIT SUCCESS
