connect / as sysdba
set feedback off
set termout off
--set echo on;

/*-------------------------------------------------------------------------------------------*/
/*  orapasswd.sql sets Oracle DB User password                                               */
/*  @(#) $Id: //bc/640-2/src/ins/SAPINST/impl/xml_internal_j2ee/components/shared/jslib/ora/tpls/ORAPASSWD.SQL#1 $ */
/*                                                                                           */
/*  usage:                                                                                   */
/*  sqlplus /NOLOG @orapasswd.sql USER PASSWD                                                */
/*                                                                                           */
/*-------------------------------------------------------------------------------------------*/

VARIABLE sUser  varchar2(100);
VARIABLE passwd  varchar2(100);

WHENEVER SQLERROR EXIT SQL.SQLCODE
WHENEVER OSERROR EXIT FAILURE

/* ---  initialization ---*/
begin
begin

  :sUser := upper('&&1');
  :passwd := '&&2';
  
end;
end;
/
set termout on
set feedback on



begin
   DECLARE
    myCursor number;
    result number;
    statement   varchar2(128);
begin


  begin
      myCursor := dbms_sql.open_cursor;
      statement := 'alter user "' || :sUser || '" identified by "' || :passwd || '"';
      dbms_sql.parse(myCursor, statement, DBMS_SQL.NATIVE);
      result := dbms_sql.execute(myCursor);
    exception
      when others then
        dbms_output.put_line('Unable to assign password to user: '|| :sUser);
        RAISE;
   end;
end;
end;
/
EXIT SUCCESS




