rem @(#) $Id: //bas/46D/src/db/ada/dbupdate74.bat#1 $ SAP
@echo off
setlocal

rem **********************************************************
rem *         Database  Initialization                       *
rem **********************************************************
rem *                                                        *
rem *         dbupdate -d <db_name> -d <dbm,dbmpasswd>       *
rem *                                                        *
rem *   db_name   : database name                            *
rem *                                                        *
rem *   parameter :                                          *
rem *        dbm:         database operator                  *
rem *        dbmpasswd:   password of database operator      *
rem *        domainpwd:   password of domain user            *
rem **********************************************************

rem --------------------- input parameters -------------------------------

set debug=opt

echo.
echo.
echo INFORMATION : This program will upgrade an existing
echo               SAP DB version greater or equal than 7.3.00.25
echo               to a newer SAP DB version 7.4            
echo.
echo               upgrade strategy:                        
echo               In-Place-Upgrade with SDBUPD             
echo.
echo               For the upgrade preparation a data backup
echo               is necessary if SAP DB version is 7.3 !
echo.
pause 


:check_input
if "%1" == "" goto end_input
if "%1" == "-d" (
  set db_name=%2
  shift  
) else if "%1" == "-u" (
  set dba_user=%2
  set dba_pwd=%3
  shift
  shift  
) else if "%1" == "-dir" (
  set output_dir=%2
) else if "%1" == "debug" (
  set debug=%2
)
shift
goto check_input
:end_input


rem ------------------------ Check the setting of all usage parameters --------------------------------------

set DBMCLI=dbmcli -d %db_name% -u %dba_user%,%dba_pwd%

IF "MY%db_name%" == "MY" (
   echo The usage parameter db_name is not set.
   goto wrong_usage
)

if "MY%dba_user%" == "MY" (
   echo The usage parameter dba_user is not set.
   goto wrong_usage
)

if "MY%dba_pwd%" == "MY" (
   echo The usage parameter dba_pwd is not set.
   goto wrong_usage
)

if "MY%output_dir%" == "MY" (
   if "MY%TEMP%" == "MY" (
	echo No TEMP variable set. 
	echo Set the environment variable TEMP or use the usage paramater -dir
        goto end_err
   ) else (
   set output_dir=%TEMP%
   )
)


rem ------------------------ Check if temporary output_dir is writeable ---------------------------------------

echo @echo off > %output_dir%\lc_wtest.bat
echo (set LCUPTEST=OK >> %output_dir%\lc_wtest.bat
echo ) >> %output_dir%\lc_wtest.bat
call %output_dir%\lc_wtest

if "MY%LCUPTEST%" == "MY" (
   echo The creation or reading of a file in directory %output_dir% failed.
   goto end_err
)


rem --------------------- DBMCLI --------------------------------------

set DBMCLI=dbmcli -d %db_name% -u %dba_user%,%dba_pwd%


rem --------------------- check that dbroot is not set  ------------------------------------

if "MY%DBROOT%" NEQ "MY" (
	echo The environment variable DBROOT is set.
	echo Delete DBROOT variable from your system and user enviroment
	echo and start DBUPDATE again.
	goto end_err
)


rem --------------------- check processor architecture  ------------------------------------

if "MY%PROCESSOR_ARCHITECTURE%" EQU "MYx86" (
	rem echo 32-BIT architecture.
        set WINCDDIR=I386
) else (
        rem echo 64-BIT architecture.
        set WINCDDIR=IA64
) 


rem --------------------- check db_name ------------------------------------

dbmcli db_enum | findstr -i %db_name% > %output_dir%\adatmp
if errorlevel 1 (
  echo The SAP DB %db_name% is not found on your host.
  echo There are the following databases defined on your host.
  dbmcli db_enum
  echo.
  goto end_err
)


rem --------------------- check DBMCLI CONNECT dbm,dbmpwd ------------------

%DBMCLI% db_state > %output_dir%\adatmp
if errorlevel 1 (
  echo dbmcli connect with %dba_user%,%dba_pwd% failed
  type %output_dir%\adatmp
  echo ERROR on %db_name% 
  echo.
  goto end_err
)


rem --------------------- check db state in output file --------------------

set COLD_OK= 1

findstr -i "COLD" %output_dir%\adatmp > %output_dir%\adatmp1
if errorlevel 0 (
set COLD_OK= 0 
)
 
findstr -i "ADMIN" %output_dir%\adatmp > %output_dir%\adatmp1
if errorlevel 0 (
set COLD_OK= 0 
)

if %COLD_OK% == 1 (
echo The database state must be COLD !
echo Bring your database to state COLD up to version 7.3
echo respectively to state ADMIN in version 7.4        
goto end_err
)



rem --------------------- get INSTROOT -------------------------------------

rem build a command script to set INSTROOT

%DBMCLI% dbm_version INSTROOT > %output_dir%\adatmp

echo @echo off > %output_dir%\instroot.bat
echo (set INSTROOT=^^>> %output_dir%\instroot.bat
findstr -v "OK" %output_dir%\adatmp >> %output_dir%\instroot.bat
echo ) >> %output_dir%\instroot.bat
call %output_dir%\instroot
rem echo INSTROOT=%INSTROOT%

if not exist %INSTROOT%\bin (
  echo.
  echo ERROR : %INSTROOT% does not exist
  echo.
  goto end_err
)

rem build a command script to set IndepProgram

%DBMCLI% dbm_getpath IndepProgPath > %output_dir%\adatmp

echo @echo off > %output_dir%\instroot.bat
echo (set IndepProg=^^>> %output_dir%\instroot.bat
findstr -v "OK" %output_dir%\adatmp >> %output_dir%\instroot.bat
echo ) >> %output_dir%\instroot.bat
call %output_dir%\instroot
rem echo IndepProg=%IndepProg%

if not exist %IndepProg% (
  echo.
  echo ERROR : %IndepProg% does not exist
  echo.
  goto end_err
)

rem build a command script to set IndepProgram

%DBMCLI% dbm_getpath IndepDataPath > %output_dir%\adatmp

echo @echo off > %output_dir%\instroot.bat
echo (set IndepData=^^>> %output_dir%\instroot.bat
findstr -v "OK" %output_dir%\adatmp >> %output_dir%\instroot.bat
echo ) >> %output_dir%\instroot.bat
call %output_dir%\instroot
rem echo IndepData=%IndepData%

if not exist %IndepData% (
  echo.
  echo ERROR : %IndepData% does not exist
  echo.
  goto end_err
)


rem echo ----------------get version string without buildnumber ---------------

%DBMCLI% dbm_version VERSION > %output_dir%\adatmp

if errorlevel 1 (
  echo .
  echo ERROR by determination of SAP DB Version
  type %output_dir%\adatmp
  echo ERROR on %db_name% 
  echo.
  goto end_err
)

echo @echo off > %output_dir%\instroot.bat
echo (set LcVersion=^^>> %output_dir%\instroot.bat
findstr -v "OK" %output_dir%\adatmp >> %output_dir%\instroot.bat
echo ) >> %output_dir%\instroot.bat
call %output_dir%\instroot
rem echo LcVersion=%LcVersion%


rem echo ----------------get fullversion string --------------------------------

%DBMCLI% dbm_version BUILD > %output_dir%\adatmp

if errorlevel 1 (
   echo .
   echo ERROR by determination of SAP DB Version
   type %output_dir%\adatmp
   echo ERROR on %db_name% 
   echo.
   goto end_err
)

echo @echo off > %output_dir%\instroot.bat
echo (set LcBuild=^^>> %output_dir%\instroot.bat
findstr -v "OK" %output_dir%\adatmp >> %output_dir%\instroot.bat
echo ) >> %output_dir%\instroot.bat
call %output_dir%\instroot
rem echo LcBuild=%LcBuild%


rem --------------------- check the minimal liveCache Version ---------------------------------------

if "MY%LcVersion%" LSS "MY7.3.0" (
    goto version_err
) 

if "MY%LcVersion%" == "MY7.3.0" (
   if "MY%LcBuild%" LSS "MYDBMServer 7.3.0    Build 025-000-000-000" (
      goto version_err 
   )
)

if "MY%LcVersion%" GTR "MY7.4.3" (
    goto version_err
) 

rem ----------------- check if SDBUPD is available -------------------------------

If not exist ..\%WINCDDIR%\SDBUPD.EXE (
  echo.
  echo ERROR: SDBUPD is not available
  echo If SAP DB RDBMS CD has been copied to disk
  echo check existance of file ..\%WINCDDIR%\SDBUPD.              
  echo Otherwise, please contact the SAP support team.
  goto end_err
)


rem ----------------- call upgrade tool --------------------------

if "MY%LcVersion%" == "MY7.3.0" (
echo.
echo C A U T I O N:                                          
echo During the upgrade the steps                            
echo - migrate database                                      
echo - migrate catalog to unicode                            
echo will need a long operating time.                        
echo. 
echo Don't cancel the execution of the upgrade.               
echo Otherwise the risk of data leakage exists !              
echo. 
pause 
)

echo.
echo Execution of SAP DB upgrade...
echo.

..\%WINCDDIR%\SDBUPD -d %db_name% -u %dba_user%,%dba_pwd%
echo %errorlevel%
echo.
echo.

if errorlevel 1 (
echo In the case of SDBUPD failure:
echo Check the above given output and 
echo the file %IndepData%\wrk\SAPDBUpdate_install-[date]-[time].log 
echo Resolve the problems and restart the installation with call:
echo  "..\%WINCDDIR%\SDBUPD -d %db_name% -u %dba_user%,%dba_pwd%
)

goto end


rem ----------------- Information about the usage of DBUPDATE ------------------------------------

:wrong_usage
  echo.
  echo USAGE : DBUPDATE -d [db_name] -u [dbm,dbmpasswd]
  echo                               -ud [domainpwd]
  echo                               -dir [directory name] optional                                    
  echo.
  echo         parameter :
  echo             dbm:            database operator
  echo             dbmpasswd:      password of database operator 
  echo             domainpwd:      password of domain user 
  echo             directory name: working directory with write permission
  echo.
  goto end_err


rem ----------------- Information about the necessary and nonexistant SAP DB version ----------

:version_err
echo Your SAP DB version isn't in the valid range of start releases.
echo The valid startrelease min: 7.3.0 Build 25 
echo                        max: 7.4.3
goto end_err

:end_err
rem set ERRORLEVEL
@verify error >NUL 2>&1

rem ---------------------------------------------------------------------
:end

