@echo off

REM *****************************************************************************
REM * The purpose of this batch script is to construct the classpath
REM * in order to call the command line tool com.sap.tc.devconf.dctool.DCToolMain
REM * 
REM * A simple check regarding the command line parameters is done
REM * in this script. If this check is passed the command line tool
REM * is called with the given option/parameters.
REM * SAP AG 2003
REM *****************************************************************************

REM check environment variables

if "%JAVA_HOME%"=="" goto usage
if "%SAPDEVSTUDIOHOME%"=="" goto usage

REM we know JAVA_HOME is set from check above!
REM Modify here if you want to use some other JRE for running DCTool
SET JAVACMD=%JAVA_HOME%\bin\java


REM construct classpath to launch dc tool

set MYCLASSPATH="%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\buildutil.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\cbsclient.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\cbscommon.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\cbsutil.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\cbswsproxy.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\classloader.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\devconflib.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\fileloader.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.build\lib\pluginHandler.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.complib\lib\complib.jar;%SAPDEVSTUDIOHOME%\plugins\com.tssap.dtr.client.vfs\com_tssap_dtr_client_vfs.jar;%SAPDEVSTUDIOHOME%\plugins\com.tssap.dtr.client.vfs\httpclient.jar;%SAPDEVSTUDIOHOME%\plugins\com.tssap.sap.libs.logging\lib\logging.jar;%SAPDEVSTUDIOHOME%\plugins\com.tssap.sap.libs.logging\lib\loggingStandard.jar;%SAPDEVSTUDIOHOME%\plugins\com.tssap.sap.libs.xmltoolkit\lib\sapxmltoolkit.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.ide.eclipse.ext.libs.iaik\lib\w3c_http.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.ide.eclipse.ext.libs.iaik\lib\iaik_ssl.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.ide.eclipse.ext.libs.iaik\lib\iaik_jce.jar;%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.security.https\lib\tc_sec_https.jar"

SET LOCALARCHIVEROOT=%SAPDEVSTUDIOHOME%\plugins\com.sap.tc.ap\comp
SET PARAM_JDK=-Dcom.sap.tc.dctool.JDK_PATH="%JAVA_HOME%"
SET PARAM_LARCHROOT=-Dcom.sap.tc.dctool.LOCALARC="%LOCALARCHIVEROOT%"


REM application to launch
set APPL=com.sap.tc.devconf.dctool.DCToolMain


if "%1"=="" goto usage

if "%1"=="help" goto help

if "%1"=="h" goto help

if "%2"=="sync" goto sync

if "%2"=="syncall" goto syncall

if "%2"=="build" goto build

if "%2"=="buildall" goto buildall

goto usage


REM %* in a batch script is a wildcard reference to all the arguments. 

:sync
REM echo executing command sync
REM Example: -c sync -f <dtc_root_folder>  -n <dcname> -v <dcvendor> -s <sc_compartment> -u <user> -p <password>

call %JAVACMD% %PARAM_LARCHROOT% -classpath %MYCLASSPATH%   %APPL%  -a %* 
goto end


:syncall
REM echo executing command syncall
REM Example: -c syncall -f <dtc_root_folder>  -u <user> -p <password>
call %JAVACMD% %PARAM_LARCHROOT%  -classpath  %MYCLASSPATH% %APPL%  -a %*
goto end


:build
REM echo executing command build
REM Example: -c build -f <dtc_root_folder>  -n <dcname> -v <dcvendor> -s <sc_compartment>
call %JAVACMD% %PARAM_LARCHROOT% %PARAM_JDK% -classpath  %MYCLASSPATH%  %APPL%  %*
goto end


:buildall
REM echo executing command buildall
REM Example: -c buildall -f <dtc_root_folder> 
call %JAVACMD% %PARAM_LARCHROOT% %PARAM_JDK% -classpath %MYCLASSPATH%  %APPL%  %*
goto end


:help
call java -classpath %MYCLASSPATH% %APPL% -h
call java -classpath %MYCLASSPATH% %APPL% -h sync
call java -classpath %MYCLASSPATH% %APPL% -h syncall
call java -classpath %MYCLASSPATH% %APPL% -h build
call java -classpath %MYCLASSPATH% %APPL% -h buildall
goto end

:usage

echo Incorrect usage, the first two parameters must be "-c <command>" where "<command>" is 
echo either sync or syncall or build or buildall.
echo Then additional parameters follow according to the specified command.
echo Examples:
echo "   -c sync -f <dtc_root_folder>   -n <dcname> -v <dcvendor> -s <sc_compartment> -u <user> -p <password>"
echo "   -c syncall -f <dtc_root_folder>  -u <user> -p <password>"
echo "   -c build -f <dtc_root_folder>   -n <dcname> -v <dcvendor> -s <sc_compartment>"
echo "   -c buildall -f <dtc_root_folder> "
echo.
echo in addition the following environment variables must be set
echo SAPDEVSTUDIOHOME: must point to the \"eclipse\" folder in your installtion of the SAP NetWeaver Developer Studio
echo JAVA_HOME:             must point to the installation folder of a Java SDK installation
echo.
echo To get more information about the command line tool that is called with this batch
echo use "help" as first parameter.
echo.
goto end


:end
REM this is the end