#!/bin/sh

# *****************************************************************************
# * 
# * Shell script to launch CBS command line tool.
# * This shell script takes the Jars from directory lib.
# * Environment vriable CBSTOOLHOME must point to the lib directory.
# * 
# * SAP AG 2004
# *
# *****************************************************************************


# check if environment variables CBSTOOLHOME and JAVA_HOME are set


if [ "$CBSTOOLHOME" = "" ] || ["$JAVA_HOME" eq "" ]
then
   echo "Incorrect usage, the following environment variables must be set:"
   echo " "
   echo "CBSTOOLHOME: must point to the "lib" folder that contains required Jars."
   echo " "
   echo "JAVA_HOME  : must point to the installation folder of a  "
   echo "             Java SDK installation "
   echo " "
   exit 1
fi




APPL=com.sap.tc.cbstool.startup.CBSToolMain
startup=$CBSTOOLHOME/cbstoolstartup.jar

# launch CBS command line tool, forward parameters that have been passed via command line
$JAVA_HOME/bin/java -classpath "$startup" -Dcbstool.jarrootdir="$CBSTOOLHOME" -Dcbstool.jarfilelist="$CBSTOOLHOME/jarlist.txt"  $APPL  $*





