@echo off

REM *****************************************************************************
REM * 
REM * Batch file to launch CBS command line tool.
REM * This batch takes the Jars from directory lib.
REM * Environment vriable CBSTOOLHOME must point to the lib directory.
REM * 
REM * SAP AG 2004
REM *
REM *****************************************************************************


if "%CBSTOOLHOME%"=="" goto usage
if "%JAVA_HOME%"=="" goto usage

set APPL=com.sap.tc.cbstool.startup.CBSToolMain
set startup=%CBSTOOLHOME%\cbstoolstartup.jar


REM launch CBS command line tool, forward parameters that have been passed via command line
call %JAVA_HOME%\bin\java -classpath "%startup%" -Dcbstool.jarrootdir="%CBSTOOLHOME%" -Dcbstool.jarfilelist="%CBSTOOLHOME%\jarlist.txt"  %APPL%  %*


goto :end

:usage

echo Incorrect usage, the following environment variables must be set:
echo.
echo CBSTOOLHOME: must point to the "lib" folder that contains required Jars.
echo JAVA_HOME:   must point to the installation folder of a 
echo              Java SDK installation
echo.
goto end

:end
REM this is the end