#!/usr/bin/perl
use strict;

my @as = qw(AbstractCollection AbstractList AbstractMap AbstractSequentialList
AbstractSet ArrayList Collection HashMap HashSet Hashtable LinkedList
List Map Set SortedMap SortedSet Stack TreeMap TreeSet Vector WeakHashMap);
#@as = sort @as;
association($_) for @as;
aggregation($_) for @as;
exit(0);

sub aggregation {
	my ($name) = @_;

	my $fn = "Aggregation$name.template";
	my $cn = "java.util.$name";

	open(FILE, "> $fn");
	print FILE <<EOF
/** \@link aggregation <{\$targetName}> */
$cn \${fieldName} = null;
EOF
;
	close(FILE);

	print <<EOF
<template
	name="Aggregation As $name"
	category="Aggregations"
	source="link/$fn"
	/>
EOF
;
}

sub association {
	my ($name) = @_;

	my $fn = "Association$name.template";
	my $cn = "java.util.$name";

	open(FILE, "> $fn");
	print FILE <<EOF
/** \@associates <{\$targetName}> */
$cn \${fieldName} = null;
EOF
;
	close(FILE);

	print <<EOF
<template
	name="Association As $name"
	category="Associations"
	source="link/$fn"
	/>
EOF
;
}
