function wdp_drag_start() {
	var _obj = event.srcElement;

	if ( _edit == false )
		return;
	
	var _rasterobj = null;
	var _rasterstr = null;
	var _foundrasterobj = null;
	for(var _i = 0; _i < _rastercount; _i++) {
		_rasterobj = _rasterobjects[_i];
		if ( _rasterobj != null ) {
			_rasterstr = _obj.refId.substr(19);
			if ( _rasterstr == _rasterobj.name ) {
				_foundrasterobj = _rasterobj;
			}
		}
	}
	if ( _foundrasterobj != null ) {
		wdp_drag_start_raster(_obj, _foundrasterobj);
	} else {
		document.getElementById("_vdresptargetid").value = _obj.refId;
		wdp_hideselection();
		
		if ( document.getElementById(_obj.refId).tableid )
			wdp_show_container_table();
		else if ( document.getElementById(_obj.refId).parentElement.toolbarid )
			wdp_show_container_toolbar();
		else
			wdp_show_container();
	}
}

function wdp_drag_start_raster(image, obj) {
	var _img = document.getElementById("_vdselectdiv");
	var _left = _img.style.left;
	var _unit = "";
	if ( _left.length > 3 ) {
		_unit = _left.substr(_left.length - 2, 2);
		if ( _unit == "px" ) {
			_left = _left.substr(0, _left.length - 2);
		}
	}
	_offsetx = event.x - _left;
	var _top = _img.style.top;
	if ( _top.length > 3 ) {
		_unit = _top.substr(_top.length - 2, 2);
		if ( _unit == "px" ) {
			_top = _top.substr(0, _top.length - 2);
		}
	}
	_offsety = event.y - _top;
	_raster = obj;
	
	var _rastercontainer = null;
	var _foundrastercontainer = null;
	var _rasterstr = "";
	for(var _i = 0; _i < _rastercont; _i++) {
		_rastercontainer = _rastercontainers[_i];
		if ( _rastercontainer != null ) {
			if ( _raster.container == _rastercontainer.name ) {
				_foundrastercontainer = _rastercontainer;
			}
		}
	}
	if ( _foundrastercontainer != null ) {
		_rasterHeight = _foundrastercontainer.rasterHeight;
		_rasterHeightUnit = _foundrastercontainer.rasterHeightUnit;
		_rasterWidth = _foundrastercontainer.rasterWidth;
		_rasterWidthUnit = _foundrastercontainer.rasterWidthUnit;
		
		wdp_align();
		
		var _img = document.getElementById("_vdselectimg");
		_img.width = _img.width - 10;
		_img.height = _img.height - 8;
	}
}

function wdp_align() {
	var _top = _raster.top;
	var _topplus = _top; _topplus++;
	var _topminus = _top; _topminus--;
	var _left = _raster.left;
	var _leftplus = _left; _leftplus++;
	var _leftminus = _left; _leftminus--;
	
	document.getElementById("_" + _raster.name + "layouttop").style.top = (_topminus * _rasterHeight) + _rasterHeightUnit;
	document.getElementById("_" + _raster.name + "layoutbottom").style.top = (_topplus * _rasterHeight) + _rasterHeightUnit;
	document.getElementById("_" + _raster.name + "layoutleft").style.left = (_leftminus * _rasterWidth) + _rasterWidthUnit;
	document.getElementById("_" + _raster.name + "layoutright").style.left = (_leftplus * _rasterWidth) + _rasterWidthUnit;
}

function wdp_align_selector() {
	var _top = _raster.top;
	var _left = _raster.left;
	var _img = document.getElementById("_vdselectdiv");

	_img.style.top = (_top * _rasterHeight) + _rasterHeightUnit;
	_img.style.left = (_left * _rasterWidth) + _rasterWidthUnit;
}

function wdp_drag_over() {
	wdp_border();
	
	window.event.returnValue = false;
}

function wdp_move() {
	if ( _raster != null ) {
		var _objRect = null;
		var _toptop = document.getElementById("_" + _raster.name + "layouttop").style.pixelTop;
		var _bottomtop = document.getElementById("_" + _raster.name + "layoutbottom").style.pixelTop;
		var _leftleft = document.getElementById("_" + _raster.name + "layoutleft").style.pixelLeft;
		var _rightleft = document.getElementById("_" + _raster.name + "layoutright").style.pixelLeft;

		if ( _toptop > event.y ) {
			_raster.top--;
		}
		if ( _bottomtop < event.y ) {
			_raster.top++;
		}
		if ( _leftleft > event.x ) {
			_raster.left--;
		}
		if ( _rightleft < event.x ) {
			_raster.left++;
		}
		wdp_align_selector();
		wdp_align();
	}
}

function wdp_white_drop() {
}

function wdp_drop() {
	var _obj = event.srcElement;
	if ( _obj.refId != "" ) {
		if ( _obj.refId )
			wdp_send(document.getElementById("_vdresptargetid").value, "drop", _obj.refId, "");
		else
			wdp_send(document.getElementById("_vdresptargetid").value, "drop", "_RootUIElementContainercont", "");
	} else
		wdp_send("", "drop", "RootUIElementContainercont", "");

	window.event.cancelBubble = true;
}

function wdp_drag_end() {
	if ( _raster != null ) {
		var _parent = document.getElementById("_vdresptargetdesign" + _raster.name).parentElement;
		_parent.style.top = (_raster.top * _rasterHeight) + _rasterHeightUnit;
		_parent.style.left = (_raster.left * _rasterWidth) + _rasterWidthUnit;
		wdp_hideselection();
		wdp_send(_raster.name + "_layoutdata", "property", "left", _raster.left);
		wdp_send(_raster.name + "_layoutdata", "property", "top", _raster.top);
	} else {
		wdp_hide_arrows();
		wdp_hide_container();
		wdp_hideselection();
	}
}

function getParent(id) {
	var _newObj = parent.document.getElementById(id);
	_newObj = _newObj.parentElement;
	while ( _newObj && _newObj.wdp == null && _newObj.id != "_vdresptargetdesign") {
		_newObj = _newObj.parentElement;
	}
	while ( _newObj && _newObj.id == "_vdresptargetdesign" ) {
		_newObj = _newObj.parentElement;
		while ( _newObj && _newObj.wdp == null ) {
			_newObj = _newObj.parentElement;
		}
	}
	return _newObj;
}

function wdp_show_container_toolbar() {
	var _obj;
	var _drop;
	var _toolbar = document.getElementById(window.event.srcElement.refId).parentElement.toolbarid;

	for(var i = 0; i < _toolbardropobjects.length; i++) {
		_obj = _toolbardropobjects[i];
		if ( _obj != "" ) {
			_drop = document.getElementById("_" + _obj.toolbarId + "_" + _obj.index + "div");
			if ( _drop != null ) {
				if ( _toolbar == _obj.toolbarId ) {
					_drop = document.getElementById("_" + _obj.toolbarId + "_" + _obj.index);
					wdp_layout_internal(_drop, "_" + _obj.toolbarId + "_" + _obj.index);
					_drop = document.getElementById("_" + _obj.toolbarId + "_" + _obj.index + "div");
					_drop.style.display = "block";
				}
			}
		}
	}
}

function wdp_show_container_table() {
	var _obj;
	var _drop;
	var _table = document.getElementById(window.event.srcElement.refId).tableid;

	for(var i = 0; i < _tabledropobjects.length; i++) {
		_obj = _tabledropobjects[i];
		if ( _obj != "" ) {
			_drop = document.getElementById("_" + _obj.columnId + "div");
			if ( _drop != null ) {
				if ( _table == _obj.tableId ) {
					_drop = document.getElementById("_vdresptargetdesign" + _obj.columnId);
					wdp_layout_internal(_drop, "_" + _obj.columnId);
					_drop = document.getElementById("_" + _obj.columnId + "div");
					_drop.style.display = "block";
				}
			}
		}
	}
}

function wdp_reset_scroll_bars() {
	var divs = document.body.getElementsByTagName("DIV");
	for(var i = 0; i < divs.length; i++) {
		if ( divs[i].className == "urTbsDspSel" || divs[i].style.position == "relative" ) {
			divs[i].scrollTop = 0;
			divs[i].scrollLeft = 0;
		}
	}
}

function wdp_show_container() {
	var _img;
	var _obj;
	
	wdp_reset_scroll_bars();
	wdp_hide_arrows();
	
	if ( _dropobjects.length < 250 ) {
	wdp_init_level_internal();
	
	for(var i = 0; i < _dropobjects.length; i++) {
		_img = _dropobjects[i];
		if ( _img != "" ) {
			_obj = document.getElementById(_img + "div");
			if ( _obj != null ) {
				wdp_layout(_img);
				_obj.style.display = "block";
			}
		}
	}
	for(var j = 0; j < _dropcontainers.length; j++) {
		_img = _dropcontainers[j];
		
		if ( _img != "" ) {
  			var _found = false;
  			for(var k = 0; k < _dropobjects.length; k++) {
  				if ( _img + "1" == _dropobjects[k] ) {
  					_found = true;
  					break;
  				}
  			}
  			//if ( _found == false ) {
  			//	wdp_layout(_img);
  			//	document.getElementById(_img + "div").style.display = "block";			
  			//} else {
  				wdp_layout_dummy(_img);
  				document.getElementById(_img + "div").style.display = "block";
  			//}
		}
	}
	}
	
	var _rootobj = document.getElementById("_vdrootimage");
	var _width;
	_width = document.body.offsetWidth - 25;
	var _height;
	_height = document.body.offsetHeight - 25;
	if ( _rootobj.width ) {
		_rootobj.width = _width;
	}
	if ( _rootobj.style.width ) {
		_rootobj.style.width = _width;
	}
	if ( _rootobj.height ) {
		_rootobj.height = _height;
	}
	if ( _rootobj.style.height ) {
		_rootobj.style.height = _height;
	}
	
	_rootobj = document.getElementById("_vdrootdiv");
	if ( document.body.scrollLeft ) {
		_rootobj.style.left  = document.body.scrollLeft;
	} else {
		_rootobj.style.left = 0;
	}
	if ( document.body.scrollTop ) {
		_rootobj.style.top = document.body.scrollTop;
	} else {
		_rootobj.style.top = 0;
	}
	
	_rootobj.style.display = "block";
}

function wdp_hide_container() {
	_raster = null;
	var _img;
	var _obj;
	for(var i = 0; i < _dropobjects.length; i++) {
		_img = _dropobjects[i];
		if ( _img != "" ) {
			_obj = document.getElementById(_img + "div");
			if ( _obj != null )
				_obj.style.display = "none";
		}
	}
	for(var j = 0; j < _dropcontainers.length; j++) {
		_img = _dropcontainers[j];
		if ( _img != "" ) {
			_obj = document.getElementById(_img + "div");
			if ( _obj != null )
				_obj.style.display = "none";
		}
	}
	for(var i = 0; i < _tabledropobjects.length; i++) {
		_obj = _tabledropobjects[i];
		if ( _obj != "" ) {
			_img = document.getElementById("_" + _obj.columnId + "div");
			if ( _img != null ) {
				_img.style.display = "none";
			}
		}
	}
	for(var i = 0; i < _toolbardropobjects.length; i++) {
		_obj = _toolbardropobjects[i];
		if ( _obj != "" ) {
			_img = document.getElementById("_" + _obj.toolbarId + "_" + _obj.index + "div");
			if ( _img != null ) {
				_img.style.display = "none";
			}
		}
	}
	_img = document.getElementById("_vdborder");
	_img.style.display = "none";
	_img = document.getElementById("_vdrootdiv");
	_img.style.display = "none";
}

function getBoundingClientRectChild(obj, objRect, level, absolutFlag) {
	if ( level == 0 )
		return objRect;

//	delete _children;
	var _children = obj.children;
//	delete _objRect;
	var _objRect = objRect;
	
	for(var i = 0; i < _children.length; i++) {
		if ( _children[i].style.position != "absolute" ) {
			delete _objTempRect;
			var _objTempRect = getBoundingClientRectChild(_children[i], _objRect, level - 1);
			if ( document.body.scrollLeft && document.body.scrollLeft > 0 ) {
				if ( _objTempRect.left <= (document.body.scrollLeft * -1) || _objTempRect.left == 0 ) {
					_objTempRect.left = 10000;
				}
			} else {
				if ( _objTempRect.left <= 0 )
					_objTempRect.left = 10000;
			}
			if ( document.body.scrollTop && document.body.scrollTop > 0 ) {
				if ( _objTempRect.top <= (document.body.scrollTop * -1) || _objTempRect.top == 0 ) {
					_objTempRect.top = 10000;
				}
			} else {
				if ( _objTempRect.top <= 0 )
					_objTempRect.top = 10000;
			}
			var _objRealRect = _children[i].getBoundingClientRect();
			if ( document.body.scrollLeft && document.body.scrollLeft > 0 ) {
				if ( _objRealRect.left <= (document.body.scrollLeft * -1) || _objRealRect.left == 0 ) {
					_objRealRect.left = 10000;
				}
			} else {
				if ( _objRealRect.left <= 0 )
					_objRealRect.left = 10000;
			}
			if ( document.body.scrollTop && document.body.scrollTop > 0 ) {
				if ( _objRealRect.top <= (document.body.scrollTop * -1) || _objRealRect.top == 0 ) {
					_objRealRect.top = 10000;
				}
			} else {
				if ( _objRealRect.top <= 0 )
					_objRealRect.top = 10000;
			}
			_objRect.left   = Math.min(_objTempRect.left, _objRealRect.left);
			_objRect.left	= Math.min(_objRect.left, objRect.left);
			_objRect.right  = Math.max(_objTempRect.right, _objRealRect.right);
			_objRect.right	= Math.max(_objRect.right, objRect.right);
			_objRect.bottom = Math.max(_objTempRect.bottom, _objRealRect.bottom);
			_objRect.bottom	= Math.max(_objRect.bottom, objRect.bottom);
			_objRect.top	= Math.min(_objTempRect.top, _objRealRect.top);
			_objRect.top	= Math.min(_objRect.top, objRect.top);
		}
	}
	return _objRect;
}

function getBoundingClientRect(obj, absolutFlag) {
	if ( obj == null )
		return;
	delete _objRect;
	var _parent = obj;
	var _offsetx = 0;
	var _offsety = 0;
	delete _parentRect;
	var _found = false;
	var _parentRect;
	if ( absolutFlag ) {
		while( _parent && _parent.id != "_vdrespdesignbody" ) {
			if ( _parent.className == "urTbsWhl" || _parent.style.position == "relative" || _parent.style.position == "absolute" ) {
				_parentRect = getBoundingClientRect(_parent, false);
				_offsetx = _offsetx + _parentRect.left;
				_offsety = _offsety + _parentRect.top;
				if ( _parent.scrollLeft ) {
					_offsetx = _offsetx - _parent.scrollLeft;
				}
				if ( _parent.scrollTop ) {
					_offsety = _offsety - _parent.scrollTop;
				}
				if ( _parent.className == "urTbsWhl" ) {
					_offsetx = _offsetx + 3;
					_offsety = _offsety + 3;
				} else {
					_offsetx = _offsetx + 1;
					_offsety = _offsety - 3;
				}
				_found = true;
				break;
			}
			_parent = _parent.parentElement;
		}
		if ( _found ) {
			if ( document.body.scrollLeft ) {
				_offsetx = _offsetx + document.body.scrollLeft;
			}
			if ( document.body.scrollTop ) {
				_offsety = _offsety + document.body.scrollTop;
			}
		}
	}
	
	var _objRect = obj.getBoundingClientRect();
	var _top    = _objRect.top;
	var _left   = _objRect.left;
	var _right  = _objRect.right;
	var _bottom = _objRect.bottom;
	_objRect = getBoundingClientRectChild(obj, _objRect, 1);
	if ( _top > 0 && _objRect.top < _top )
		_objRect.top = _top;
	if ( _left > 0 && _objRect.left < _left )
		_objRect.left = _left;
	if ( _bottom > 0 && _objRect.bottom > _bottom )
		_objRect.bottom = _bottom;

	_objRect.top = _objRect.top - _offsety;
	_objRect.left = _objRect.left - _offsetx;
	_objRect.bottom = _objRect.bottom - _offsety;
	_objRect.right = _objRect.right - _offsetx;

	return _objRect;
}

function wdp_layout(id) {
	var _obj = document.getElementById(id);
	if ( _obj == null )
		return;
		
	wdp_layout_internal(_obj, id);
}

function wdp_layout_dummy(id) {
	var _obj = document.getElementById(id);
	if ( _obj == null )
		return;
		
	wdp_layout_dummy_internal(_obj, id);
}
		
function wdp_layout_internal(obj, id) {
	var _string;
	_string = id + "image";
	var _objRect = getBoundingClientRect(obj, true);

	var _img = document.getElementById(_string);
	var _width;
	var _height;
	_width = (_objRect.right - _objRect.left);
	if ( _width < 20 ) {
		_width = 20;
	}
	//_width = _width - 7;
	if ( _img.width ) {
		_img.width = _width;
	}
	if ( _img.style.width ) {
		_img.style.width = _width;
	}
	_height = (_objRect.bottom - _objRect.top);
	_height = _height - 7;
	if ( _height < 15 )
		_height = 15;
	if ( _img.height ) {
		_img.height = _height;
	}
	if ( _img.style.height ) {
		_img.style.height = _height;
	}

	_string = id + "div";
	_img = document.getElementById(_string);
	var _left;
	var _top;
	_left = (_objRect.left + _objRect.right) / 2;
	_left = _left - _width / 2 - 3;
	if ( document.body.scrollLeft ) {
		_img.style.left  = _left + document.body.scrollLeft;
		_img.style.right = _left + _width + document.body.scrollLeft;
		_img.style.width = _width;
	} else {
		_img.style.left = _left;
		_img.style.right = _left + _width;
		_img.style.width = _width;
	}
	_top = (_objRect.top + _objRect.bottom) / 2;
	_top = _top - _height / 2 - 3;
	if ( document.body.scrollTop ) {
		_img.style.top = _top + document.body.scrollTop;
		_img.style.bottom = _top + _height + document.body.scrollTop;
		_img.style.height = _height;
	} else {
		_img.style.top = _top;
		_img.style.bottom = _top + _height;
		_img.style.height = _height;
	}
}

function wdp_layout_dummy_internal(obj, id) {
	var _string;
	_string = id + "image";
	var _objRect = getBoundingClientRect(obj, true);

	var _img = document.getElementById(_string);
	var _width;
	var _height;
	_width = 15;
	if ( _img.width ) {
		_img.width = _width;
	}
	if ( _img.style.width ) {
		_img.style.width = _width;
	}
	_height = 15;
	if ( _img.height ) {
		_img.height = _height;
	}
	if ( _img.style.height ) {
		_img.style.height = _height;
	}

	_string = id + "div";
	_img = document.getElementById(_string);
	var _left;
	var _top;
	_left = _objRect.right;
	_left = _left - _width / 2 - 3;
	if ( document.body.scrollLeft ) {
		_img.style.left  = _left + document.body.scrollLeft;
		_img.style.right = _left + _width + document.body.scrollLeft;
		_img.style.width = _width;
	} else {
		_img.style.left = _left;
		_img.style.right = _left + _width;
		_img.style.width = _width;
	}
	_top = _objRect.bottom;
	_top = _top - _height / 2 - 3;
	if ( document.body.scrollTop ) {
		_img.style.top = _top + document.body.scrollTop;
		_img.style.bottom = _top + _height + document.body.scrollTop;
		_img.style.height = _height;
	} else {
		_img.style.top = _top;
		_img.style.bottom = _top + _height;
		_img.style.height = _height;
	}
}

function wdp_border() {
	if ( event.srcElement != null ) {
		var _obj = event.srcElement;
		if ( _obj.refId != null ) {
			var _refObj = _obj;
			var _objRect = getBoundingClientRect(_obj, false);

			var _img = document.getElementById("_vdborder");
			if ( _img != null ) {
				var _width;
				var _height;
				var _top;
				var _bottom;
				_width = (_objRect.right - _objRect.left) + 2;
				_height = (_objRect.bottom - _objRect.top) + 2;
				_left = _objRect.left - 4;
				if ( document.body.scrollLeft ) {
					_img.style.left = _left + document.body.scrollLeft;
					_img.style.right = _left + _width + document.body.scrollLeft;
					_img.style.width = _width;
				} else {
					_img.style.left = _left;
					_img.style.right = _left + _width;
					_img.style.width = _width;
				}
				_top = _objRect.top - 4;
				if ( document.body.scrollTop ) {
					_img.style.top = _top + document.body.scrollTop;
					_img.style.bottom = _top + _height + document.body.scrollTop;
					_img.style.height = _height;
				} else {
					_img.style.top = _top;
					_img.style.bottom = _top + _height;
					_img.style.height = _height;
				}
				_img.style.display = "block";
				
				_img = document.getElementById("_vdborderimage");
				if ( _img.width ) {
					_img.width = _width;
				}
				if ( _img.style.width ) {
					_img.style.width = _width;
				}
				if ( _img.height ) {
					_img.height = _height;
				}
				if ( _img.style.height ) {
					_img.style.height = _height;
				}
				_img.style.display = "block";
			}
		}
	}
}

function wdp_delete_item(id, nr) {
	var _string = "_" + id + "cont" + nr;
	for(var i = 0; i < _dropobjects.length; i++) {
		if ( _dropobjects[i] == _string ) {
			_dropobjects[i] = "";
			return;
		}
	}
}

function wdp_init_level_internal() {
	var _obj;
	for(var i = 0; i < _levelobjects.length; i++) {
		_obj = _levelobjects[i];
		wdp_set_level_internal(_obj.id, _obj.nr, _obj.level);
	}
}

function wdp_set_level_internal(id, nr, level) {
	var _string;
	for(var i = 0; i < nr; i++) {
		_string = "_" + id + "cont" + (i + 1) + "div";
		if ( document.getElementById(_string) != null ) {
			var _parent = document.getElementById(_string).parentElement;
			while( _parent.id != "_vdrespdesignbody" ) {
				if ( _parent.className == "urTbsWhl" || _parent.style.position == "absolute" || _parent.style.position == "relative" ) {
					_parent.style.zIndex = level * 2;
				}
				_parent = _parent.parentElement;
			}
			document.getElementById(_string).style.zIndex = level * 2;
		}
	}
	_string = "_" + id + "contdiv";
	if ( document.getElementById(_string) != null ) {
		var _parent = document.getElementById(_string).parentElement;
		if ( id == "RootUIElementContainer" ) {
			document.getElementById(_string).style.zIndex = 0;
		} else {
			while( _parent.id != "_vdrespdesignbody" ) {
				if ( _parent.className == "urTbsWhl" || _parent.style.position == "absolute" || _parent.style.position == "relative" ) {
					_parent.style.zIndex = level * 2;
				}
				_parent = _parent.parentElement;
			}
			document.getElementById(_string).style.zIndex = level * 2;
		}
	}
}

function LevelObject(i, n, l) {
	this.id = i;
	this.nr = n;
	this.level = l;
}

function wdp_clear_level() {
	_levelobjects = new Array();
	_levelcount = 0;
}

function wdp_set_level(id, nr, level) {
	var _obj = new LevelObject(id, nr, level);
	_levelobjects[_levelcount++] = _obj;	
}

function wdp_insert_item(id, nr) {
	var _string = "_" + id + "cont" + nr;
	for(var j = 0; j < _dropobjects.length; j++) {
		if ( _dropobjects[j] == id )
			return;
	}
	for(var i = 0; i < _dropobjects.length; i++) {
		if ( _dropobjects[i] == "" ) {
			_dropobjects[i] = _string;
			return;
		}
	}
	_dropobjects[_objcount++] = _string;
}

function wdp_delete_container(id) {
	var _string = "_" + id + "cont";
	for(var i = 0; i < _dropcontainers.length; i++) {
		if ( _dropcontainers[i] == _string ) {
			_dropcontainers[i] = "";
			return;
		}
	}
}

function wdp_set_level_container(id, level) {
	var _string = "_" + id + "contdiv";
	document.getElementById(_string).style.zIndex = level;
}

function wdp_insert_container(id) {
	var _string = "_" + id + "cont";
	for(var j = 0; j < _dropcontainers.length; j++) {
		if ( _dropcontainers[j] == _string )
			return;
	}
	for(var i = 0; i < _dropcontainers.length; i++) {
		if ( _dropcontainers[i] == "" ) {
			_dropcontainers[i] = _string;
			return;
		}
	}
	_dropobjects[_objcount++] = _string;
}

function wdp_clear_id() {
	document.getElementById("_vdresptargetid").value = "";
}

function wdp_show_selector(id) {
	wdp_hide_arrows();
	wdp_hide_menu();
	var _obj = document.getElementById(id);
	document.getElementById("_vdresptargetid").value = id;
	
	if ( _obj ) {
		delete _objRect;
		var _objRect = getBoundingClientRect(_obj, false);
		var _img = document.getElementById("_vdselectdiv");

		if ( _objRect.right != 0 || _objRect.left != 10000 ) {		
			if ( document.body.scrollLeft ) {
				_img.style.left = _objRect.left + document.body.scrollLeft - 7;
				_img.style.right = _objRect.right + document.body.scrollLeft - 7;
				_img.style.width = _objRect.right - _objRect.left;
			} else {
				_img.style.left = _objRect.left - 7;
				_img.style.right = _objRect.right - 7;
				_img.style.width = _objRect.right - _objRect.left;
			}
			if ( document.body.scrollTop ) {
				_img.style.top = _objRect.top + document.body.scrollTop - 7;
			} else {
				_img.style.top = _objRect.top - 7;
			}
			_img.style.display = "block";
			
			_img = document.getElementById("_vdselectimg");
			if ( _img.width )
				_img.width = _objRect.right - _objRect.left + 10;
			if ( _img.style.width )
				_img.style.width = _objRect.right - _objRect.left + 10;
			if ( _img.height )
				_img.height = _objRect.bottom - _objRect.top + 8;
			if ( _img.style.height ) 
				_img.style.height = _objRect.bottom - _objRect.top + 8;
				
			_img.refId = id;
			if (_obj.parentElement.parentElement.toolbarid) {
				_img.toolbar = "true";
				_img.table   = "false";
			} else {
				_img.toolbar = "false";
			}
		
			if ( document.getElementById(id).table ) {
				_img.table = "true";
				_img.toolbar = "false";
			} else {
				_img.table   = "false";
				_img.toolbar = "false";
			}
		}
		if ( id.length > 19 ) {
			var _id = id.substr(19);
			var _vdd = document.getElementById("_vddhorizontal" + _id);
			var _rect = getBoundingClientRect(document.getElementById(_id), true);
			if ( _vdd ) {
				if ( document.body.scrollLeft )
					_vdd.style.left = _rect.right + 4 + document.body.scrollLeft;
				else
					_vdd.style.left = _rect.right + 4;
				if ( document.body.scrollTop )
					_vdd.style.top = (_rect.bottom + _rect.top) / 2 - 6 + document.body.scrollTop;
				else
					_vdd.style.top = (_rect.bottom + _rect.top) / 2 - 6;
				_vdd.style.display = "block";
			}
			_vdd = document.getElementById("_vddvertical" + _id);
			if ( _vdd ) {
				if ( document.body.scrollTop )
					_vdd.style.top = _rect.bottom + document.body.scrollTop;
				else
					_vdd.style.top = _rect.bottom;
				if ( document.body.scrollLeft )
					_vdd.style.left = (_rect.left + _rect.right) / 2 + document.body.scrollLeft;
				else
					_vdd.style.left = (_rect.left + _rect.right) / 2;
				_vdd.style.display = "block";
			}
		}
	}
}

function wdp_send(id, event, param1, param2) {
	document.getElementById("_vdresptargetid").value = id;
	document.getElementById("_vdresptargetevent").value = event;
	document.getElementById("_vdresptargetparam1").value = param1;
	document.getElementById("_vdresptargetparam2").value = param2;
	var date = new Date();
	document.getElementById("_vdresptargetcookie").value = date.toUTCString() + date.getUTCMilliseconds();
	document.all["_vdrespform"].submit();
}

function wdp_click() {
	_transaction = true;
	var _newObj = event.srcElement;
	while ( _newObj && _newObj.wdp == null && _newObj.id != "_vdresptargetdesign") {
		_newObj = _newObj.parentElement;
	}
	while ( _newObj && _newObj.id == "_vdresptargetdesign" ) {
		_newObj = _newObj.parentElement;
		while ( _newObj && _newObj.wdp == null ) {
			_newObj = _newObj.parentElement;
		}
	}
	if ( _newObj && _newObj.id ) {
		select(_newObj.id);
		document.getElementById("_vdresptargetid").value = _newObj.id;
	} else {
		if ( event.srcElement.id != "_vdselectimg" ) {
			window.event.cancelBubble = true;
			wdp_hideselection();
		}
	}
}

function wdp_nothing() {
	window.event.returnValue = false;
}

function UR_CbxClick() {
}

function UR_TrayCreate() {
}

function UR_TabStripCreate(strId,intCount,intActive) {
  with(document) {
		var iMaxHeight = 0;
		var h    ="";
		for (var n=0;n<intCount;n++) {
		  var oContent = getElementById(strId+"content"+n);
		  with(oContent) {
        iHeight = offsetHeight;
        if (n!=intActive) {
        	oContent.style.display="none";
        }
			  if (iMaxHeight<iHeight) iMaxHeight=iHeight;
			}
		}
		for (var n=0;n<intCount;n++) {
		  var oContent = getElementById(strId+"content"+n);
		  with(oContent) {
		  	oContent.style.height=iMaxHeight;
		  	oContent.setAttribute("oldheight",iMaxHeight);
      }
    }
	}
}

function select(id) {
	wdp_hide_container();
	wdp_show_selector(id);
	wdp_send(id, "select", "", "");
	window.event.cancelBubble = true;
}

function wdp_key() {
	if ( document.getElementById("_vdresptargetid").value != "" ) {
		var _obj = document.getElementById(document.getElementById("_vdresptargetid").value);
		
		if ( _obj && window.event.keyCode == 27) {
			var _newObj = _obj.parentElement;
			while ( _newObj && _newObj.wdp == null ) {
				_newObj = _newObj.parentElement;
			}
			if ( _newObj && _newObj.id ) {
				select(_newObj.id);
			}
		} else if ( _obj && window.event.keyCode == 46) {
			wdp_send(document.getElementById("_vdresptargetid").value, "delete", "", "");
		}
	}
	window.event.keyCode = 0;
}

function wdp_update(id) {
	wdp_hide_menu();
	document.all["_vdrespdelta"].submit();
}

function wdp_update2(id, id2) {
	wdp_send(id, "update", "", "");
}

function wdp_hideselection() {
	document.getElementById("_vdselectdiv").style.display = "none";
	wdp_hide_menu();
}

function wdp_hide_arrows() {
	var _img = document.getElementById("_vdselectimg");
	if ( _img && _img.refId ) {
		if ( _img.refId.length > 19 ) {
			var _id = _img.refId.substr(19);
			var _vdd = document.getElementById("_vddhorizontal" + _id);
			if ( _vdd ) {
				_vdd.style.display = "none";
			}
			var _vdd = document.getElementById("_vddvertical" + _id);
			if ( _vdd ) {
				_vdd.style.display = "none";
			}
		}
	}
}

function wdp_tabchange(strId, intNewIdx, intOldIdx)
{
	if ( _edit == false ) {
		return;
	}
	wdp_hideselection();
	urMAPI_TabStripItem_setActive(strId,intNewIdx);
	wdp_send(strId, "property", "selectedTab", intNewIdx);
	window.event.cancelBubble = true;
}

function wdp_traytoggle( idTray, nCancelState)
{
	if ( _edit == false ) {
		return true;
	}
	wdp_hideselection();
	
	UR_TrcToggle(idTray, nCancelState);
	
	var elBody = document.all(idTray+"-bd");
	var ret = "true";
	if ( elBody != null ) {
		if ( elBody.style.display == "none" ) {
			ret = "false";
		}
	}
	
	wdp_send(idTray, "property", "Expanded", ret);
	
	window.event.cancelBubble = true;
	return true;
}

function trace(message) {
	var _traceobj = document.getElementById("_trace");
	
	if ( _traceobj != null ) {
		_traceobj.innerHTML = _traceobj.innerHTML + "<div><nobr>" + message + "</nobr></div>";
	}
}

function TableDropObject(t, c, i) {
	this.tableId = t;
	this.columnId = c;
	this.index = i;
}

function ToolbarDropObject(t, i) {
	this.toolbarId = t;
	this.index = i;
}

function wdp_table_drop(tableId, columnId, index) {
	for(var i = 0; i < _tabledropobjects.length; i++) {
		if ( _tabledropobjects[i] == "" ) {
			_tabledropobjects[i] = new TableDropObject(tableId, columnId, index);
			return;
		}
	}
	_tabledropobjects[_tabledropcount++] = new TableDropObject(tableId, columnId, index);
}

function wdp_table_drop_delete(tableId, columnId, index) {
	var _obj;
	for(var i = 0; i < _tabledropobjects.length; i++) {
		_obj = _tabledropobjects[i];
		if ( tableId == _obj.tableId && columnId == _obj.columnId ) {
			_tabledropobjects[i] = "";
			return;
		}
	}
}

function wdp_toolbar_drop(toolbarId, index) {
	for(var i = 0; i < _toolbardropobjects.length; i++) {
		if ( _toolbardropobjects[i] == "" ) {
			_toolbardropobjects[i] = new ToolbarDropObject(toolbarId, index);
			return;
		}
	}
	_toolbardropobjects[_toolbardropcount++] = new ToolbarDropObject(toolbarId, index);
}

function wdp_toolbar_drop_delete(toolbarId, index) {
	var _obj;
	for(var i = 0; i < _toolbardropobjects.length; i++) {
		_obj = _toolbardropobjects[i];
		if ( toolbarId == _obj.toolbarId && index == _obj.index ) {
			_toolbardropobjects[i] = "";
			return;
		}		
	}
}

function wdp_resize_horizontal(id, type, property) {
	wdp_hideselection();
	if ( type == "discrete" ) {
		wdp_resize_horizontal_discrete(id, property);
	}
	if ( type == "flow" ) {
		wdp_resize_horizontal_flow(id, property);
	}
}

function wdp_resize_vertical(id, type, property) {
	wdp_hideselection();
	if ( type == "discrete" ) {
		wdp_resize_vertical_discrete(id, property);
	}
	if ( type == "flow" ) {
		wdp_resize_vertical_flow(id, property);
	}
}

function wdp_resize_horizontal_discrete(id, property) {
	var _dr = document.getElementById("_vddhorizontal" + id);
	if ( _dr ) {
		_dr.style.left = event.x - 8;
		var _inp = document.getElementById(id);
		var _rec = getBoundingClientRectResize(_inp, true);
		if ( _rec.right < event.x ) {
			_inp.setAttribute(property, _inp.getAttribute(property) + 1);
		} else if ( _rec.right > event.x + 5) {
			var _temp = _inp.getAttribute(property);
			if ( _temp > 1 )
				_inp.setAttribute(property, _inp.getAttribute(property) - 1);
		}
	}
}

function wdp_resize_horizontal_flow(id, property) {
	var _dr = document.getElementById("_vddhorizontal" + id);
	if ( _dr ) {
		if ( document.body.scrollLeft )
			_dr.style.left = event.x - 5 + document.body.scrollLeft;
		else
			_dr.style.left = event.x - 5;
		var _inp = document.getElementById(id);
		var _rec = getBoundingClientRectResize(_inp, true);
		_inp.style.setAttribute(property, event.x - _rec.left);
	}
}

function wdp_resize_vertical_discrete(id, property) {
	var _dr = document.getElementById("_vddvertical" + id);
	if ( _dr ) {
		_dr.style.top = event.y - 8;
		var _inp = document.getElementById(id);
		var _rec = getBoundingClientRectResize(_inp, true);
		if ( _rec.bottom < event.y ) {
			_inp.setAttribute(property, _inp.getAttribute(property) + 1);
		} else if ( _rec.bottom > event.y + 5) {
			var _temp = _inp.getAttribute(property);
			if ( _temp > 1 )
				_inp.setAttribute(property, _inp.getAttribute(property) - 1);
		}
	}
}

function wdp_resize_vertical_flow(id, property) {
	var _dr = document.getElementById("_vddvertical" + id);
	if ( _dr ) {
		if ( document.body.scrollTop )
			_dr.style.top = event.y - 5 + document.body.scrollTop;
		else
			_dr.style.top = event.y - 5;
		var _inp = document.getElementById(id);
		var _rec = getBoundingClientRectResize(_inp, true);
		_inp.style.setAttribute(property, event.y - _rec.top);
	}
}

function wdp_set_property(id, type, property, objproperty) {
	var _value;
	var _inp = document.getElementById(id);
	if ( _inp ) {
		if ( type == "discrete" ) {
			_value = _inp.getAttribute(property);
		}
		if ( type == "flow" ) {
			_value = _inp.style.getAttribute(property);
		}	
		wdp_send(id, "property", objproperty, _value);
	}
	_inp = document.getElementById("_vddhorizontal" + id);
	if ( _inp ) {
		_inp.style.display = "none";
	}
	_inp = document.getElementById("_vddvertical" + id);
	if ( _inp ) {
		_inp.style.display = "none";
	}
}

function getBoundingClientRectResize(obj, absolutFlag) {
	if ( obj == null )
		return;
	delete _objRect;
	var _parent = obj;
	var _offsetx = 0;
	var _offsety = 0;
	delete _parentRect;
	var _parentRect;
	var _found = false;
	var _lastx = 0;
	var _lasty = 0;
	if ( absolutFlag ) {
		while( _parent && _parent.id != "_vdrespdesignbody" ) {
			if ( _parent.className == "urTbsWhl" || _parent.style.position == "relative" || _parent.style.position == "absolute" ) {
				_parentRect = getBoundingClientRect(_parent, false);
				_offsetx = _offsetx + _parentRect.left - _lastx;
				_offsety = _offsety + _parentRect.top  - _lasty;
				_lastx = _parentRect.left;
				_lasty = _parentRect.top;
				if ( _parent.scrollLeft ) {
					_offsetx = _offsetx - _parent.scrollLeft;
				}
				if ( _parent.scrollTop ) {
					_offsety = _offsety - _parent.scrollTop;
				}
				if ( _parent.className == "urTbsWhl" ) {
					_offsetx = _offsetx + 3;
					_offsety = _offsety + 3;
				} else {
					_offsetx = _offsetx - 3;
					_offsety = _offsety - 3;
				}
				
				_found = true;
				break;
			}
			_parent = _parent.parentElement;
		}
	}
	
	var _objRect = obj.getBoundingClientRect();
	var _top    = _objRect.top;
	var _left   = _objRect.left;
	var _right  = _objRect.right;
	var _bottom = _objRect.bottom;
		
	_objRect.top = _objRect.top - _offsety;
	_objRect.left = _objRect.left - _offsetx;
	_objRect.bottom = _objRect.bottom - _offsety;
	_objRect.right = _objRect.right - _offsetx;
	return _objRect;
}

function MenuItem(n, t, a) {
	this.name = n;
	this.text = t;
	this.action = a;
}

function wdp_show_menu() {
	wdp_click();
	var _id = document.getElementById("_vdresptargetid").value;
	if ( _id == "" ) {
		return false;
	}
	if ( document.getElementById("_vdselectdiv").style.display == "none" )
		return false;
	if ( _edit == false )
		return false;
	var _menu = document.getElementById("_menu");
	if ( _menu ) {
		var _rightedge = document.body.clientWidth-event.clientX;
		var _bottomedge = document.body.clientHeight-event.clientY;
		if ( _rightedge < _menu.offsetWidth )
			_menu.style.left = document.body.scrollLeft + event.clientX - _menu.offsetWidth;
		else
			_menu.style.left = document.body.scrollLeft + event.clientX;
		if ( _bottomedge < _menu.offsetHeight )
			_menu.style.top = document.body.scrollTop + event.clientY - _menu.offsetHeight;
		else
			_menu.style.top = document.body.scrollTop + event.clientY;
		wdp_insert_items(_menu);
		_menu.style.visibility = "visible";
	}
	return false;
}

function wdp_insert_items(menu) {
	var _id = document.getElementById("_vdresptargetid").value;
	if ( _id.length > 19 )
		_id = _id.substr(19);
	menu.innerHTML = '<div action="" class="menuitemsenbl"><nobr>ID: <b>' + _id + '</b></nobr></div><hr/>';
	
	menu.innerHTML = menu.innerHTML + '<div action="delete" class="menuitemsenbl">' + document.getElementById("_vdnamedelete").value + '</div><hr/>';
	menu.innerHTML = menu.innerHTML + '<div action="cut" class="menuitemsenbl">' + document.getElementById("_vdnamecut").value + '</div>';
	menu.innerHTML = menu.innerHTML + '<div action="copy" class="menuitemsenbl">' + document.getElementById("_vdnamecopy").value + '</div>';
	if ( _pasteIsAllowed )
		menu.innerHTML = menu.innerHTML + '<div action="paste" class="menuitemsenbl">' + document.getElementById("_vdnamepaste").value + '</div>';
	else
		menu.innerHTML = menu.innerHTML + '<div action="" class="menuitemsdsbl">' + document.getElementById("_vdnamepaste").value + '</div>';

	var _item;
	var _found = false;
	var _texts = new Array();
	for(var i = 0; i < _menuobjects.length; i++) {
		_item = _menuobjects[i];
		if ( _id == _item.name && _texts[_item.text] == null ) {
			if ( !_found ) {
				menu.innerHTML = menu.innerHTML + '<hr/>';
				_found = true;
			}
			menu.innerHTML = menu.innerHTML + '<div action="' + _item.action + '" class="menuitemsenbl">' + _item.text + '</div>';
			_texts[_item.text] = true;
		}
	}
	menu.innerHTML = menu.innerHTML + '<hr/><div action="properties" class="menuitemsenbl">' + document.getElementById("_vdnameproperties").value + '</div>';
}

function wdp_hide_menu() {
	var _menu = document.getElementById("_menu");
	if ( _menu ) {
		_menu.style.visibility = "hidden";
	}
}

function wdp_highlight() {
	if ( event.srcElement.className == "menuitemsenbl" && event.srcElement.action != "" ) {
		event.srcElement.style.backgroundColor = "highlight";
		event.srcElement.style.color = "white";
	}
}

function wdp_lowlight() {
	if ( event.srcElement.className == "menuitemsenbl") {
		event.srcElement.style.backgroundColor = "";
		event.srcElement.style.color = "black";
	}
}

function wdp_item_select() {
	if ( event.srcElement.action == "delete" )
		wdp_send(document.getElementById("_vdresptargetid").value, "delete", "", "");
	else if ( event.srcElement.action != "" )
		wdp_send(document.getElementById("_vdresptargetid").value, "context", event.srcElement.action, "");
	wdp_hide_menu();	
}

function wdp_menu_item(id, text, action) {
	for(var i = 0; i < _menuobjects.length; i++) {
		if ( _menuobjects[i] == "" ) {
			_menuobjects[i] = new MenuItem(id, text, action);
			return;
		}
	}
	_menuobjects[_menucount++] = new MenuItem(id, text, action);
}

function wdp_menu_item_delete(id) {
	for(var i = 0; i < _menuobjects.length; i++) {
		if ( _menuobjects[i].name == id ) {
			_menuobjects[i] = "";
		}
	}
}

function wdp_edit_on() {
	_edit = true;
}

function wdp_edit_off() {
	_edit = false;
}

function wdp_paste_allowed() {
	_pasteIsAllowed = true;
}

function wdp_paste_not_allowed() {
	_pasteIsAllowed = false;
}

function RasterItem(n, c, t, l) {
	this.name = n;
	this.container = c;
	this.top = t;
	this.left = l;
}

function RasterCont(n, h, w, hu, wu) {
	this.name = n;
	this.rasterHeight = h;
	this.rasterWidth  = w;
	this.rasterHeightUnit = hu;
	this.rasterWidthUnit  = wu;
}

function UR_TabStripCreate(strId,intCount,intActive) {
  with(document) {
		var iMaxHeight = 0;
		var h    ="";
		for (var n=0;n<intCount;n++) {
		  var oContent = getElementById(strId+"content"+n);
		  with(oContent) {
        iHeight = offsetHeight;
        if (n!=intActive) {
        	oContent.style.display="none";
        }
			  if (iMaxHeight<iHeight) iMaxHeight=iHeight;
			}
		}
		for (var n=0;n<intCount;n++) {
		  var oContent = getElementById(strId+"content"+n);
		  with(oContent) {
		  	oContent.style.height=iMaxHeight;
		  	oContent.setAttribute("oldheight",iMaxHeight);
      }
    }
	}
}

function UR_PCSeqCreate(strId,bCollapsed,intCount,intActive) {
	//sapUrMapi_PcSeq_create(strId, intCount, intActive, bCollapsed);
}

function UR_PCCreate(strId,bCollapsed) {
	//sapUrMapi_Pc_Create(strId, bCollapsed );
}

function UR_PCTabsCreate(strId,bCollapsed,intCount,intActive) {
	//sapUrMapi_PcTabs_create(strId, intCount, intActive, bCollapsed);
}
