Option Explicit

'Variables for script engine
Dim WshShell, objShell, FSO, cmdLine
'Variables for enviroment and path
Dim EclipsePath, SourcePath, targetPath, updateCmdPath, tmpFile, iniFile, logFile

Const BIF_BROWSEFORCOMPUTER = &H1000
Const BIF_BROWSEFORPRINTER = &H2000
Const BIF_BROWSEINCLUDEFILES = &H4000
Const BIF_BROWSEINCLUDEURLS = &H80
Const BIF_DONTGOBELOWDOMAIN = &H2
Const BIF_EDITBOX = &H10
Const BIF_NEWDIALOGSTYLE = &H40
Const BIF_NONEWFOLDERBUTTON = &H200
Const BIF_RETURNFSANCESTORS = &H8
Const BIF_RETURNONLYFSDIRS = &H1
Const BIF_SHAREABLE = &H8000
Const BIF_STATUSTEXT = &H4
Const BIF_UAHINT = &H100
Const BIF_USENEWUI = &H40
Const BIF_VALIDATE = &H20
'*********************************************************************************************
Set objShell = Wscript.CreateObject("Shell.Application")
Set WshShell = Wscript.CreateObject("Wscript.Shell")
Set fso = CreateObject("Scripting.FileSystemObject")
SourcePath = fso.GetParentFolderName(Wscript.ScriptFullName)
EclipsePath = SourcePATH & "\" & "eclipse"
'*********************************************************************************************

targetPath = GetFolderNameFromBrowse()
updateCmdPath = "\\pwdf0585\IdeStatus\update.cmd"
logFile = GetLogFile

if targetPath <> "" then

  targetPath = targetPath & "\eclipse"
  iniFile = targetPath & "\plugins\com.sap.java.ide\plugin_customization.ini"
  tmpFile = fso.GetSpecialFolder(2) & "\" & fso.GetTempName

  if fso.FileExists(iniFile) then
    'Save old plugin_customization.ini file
    fso.CopyFile iniFile, tmpFile, true
 
    'MsgBox "The folder """ & targetPath & """ doesn't contain a previous installated NetWeaver Developer Studio version. You should have a first installation with SapSetup.", vbsystemmodal + vbCritical, "Update failed"
    'wscript.quit
  end if

  'run robocoy
  cmdLine = updateCmdPath & " """ & EclipsePath & """ """ & targetPath & """ """ & logFile & """"
  WshShell.Run cmdLine, 1, True 

  if fso.FileExists(tmpFile) then
    'Restore old plugin_customization.ini file
    fso.CopyFile tmpFile, iniFile, true
    fso.DeleteFile tmpFile
  end if

end if

'*********************************************************************************************
function GetFolderNameFromBrowse()

     Dim oBrowseFolder

     set oBrowseFolder = objShell.BrowseForFolder(0, "Select folder where your SAP NetWeaver Developer Studion installation is (e.g. C:\Program Files\SAP\JDT).", BIF_RETURNONLYFSDIRS OR BIF_USENEWUI OR BIF_UAHINT OR BIF_BROWSEINCLUDEURLS OR BIF_EDITBOX)

     if (oBrowseFolder is nothing) then
          GetFolderNameFromBrowse = ""
          exit function
     end if

     GetFolderNameFromBrowse = oBrowseFolder.Self.Path
end function
'*********************************************************************************************


function GetLogFile() 

  Dim dteCurrent
  Dim dteDay, dteMonth, dteYear
  Dim dteHour, dteMinute
  Dim MyDate

  dteCurrent = Now()
  dteDay = Day(dteCurrent)
  if dteDay < 10 then
    dteDay = "0" & dteDay
  end if
  dteMonth = Month(dteCurrent)
  if dteMonth < 10 then
    dteMonth = "0" & dteMonth
  end if
  dteYear = Year(dteCurrent)
  dteHour = Hour(dteCurrent)
  if dteHour < 10 then
    dteHour = "0" & dteHour
  end if
  dteMinute = Minute(dteCurrent)
  if dteMinute < 10 then
    dteMinute = "0" & dteMinute
  end if

  MyDate = dteYear & dteMonth & dteDay & "_" & dteHour & dteMinute
  
  GetLogFile = fso.GetSpecialFolder(2) & "\update" & MyDate & ".log"
  
end Function