package com.inqmy.ats.system.tools;


import java.util.*;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipEntry;

import java.io.*;

public class Utilities {



  public static final String OS_NAME = System.getProperty("os.name").toLowerCase();
  public static Properties systemVars;


  public static String escapeOS(String str){
    if (OS_NAME.indexOf("windows") != -1 ) {
      return "\"" + str + "\"";
    } else if((OS_NAME.indexOf("solaris") != -1) || (OS_NAME.indexOf("linux") != -1) || (OS_NAME.indexOf("unix") != -1) ) {
      StringBuffer buffer = new StringBuffer(255);
      StringTokenizer stringtokenizer = new StringTokenizer(str , " ");
      if(stringtokenizer.hasMoreTokens())   {
        buffer.append(stringtokenizer.nextToken());
      }
      while(stringtokenizer.hasMoreTokens() ) {
        buffer.append("\\ ").append(stringtokenizer.nextToken());
      }
      return buffer.toString();
    } else {
      throw new RuntimeException("Not supported platform : "+OS_NAME);
    }
  }
  public static String trim(String string) {
    if(string == null) {
      return null;
    }
    char aChar;
    int len = string.length();
    StringBuffer outBuffer = new StringBuffer(len);

   for(int x=0; x<len; ) {
      aChar = string.charAt(x++);
      if (aChar == '\\') {
        aChar = string.charAt(x++);
        outBuffer.append(aChar);
      } else {
        outBuffer.append(aChar);
      }
    }
    return outBuffer.toString();
  }

  public static String appendAfter(String source , char symbol , char appendSymbol) {
    if(source == null) {
      return null;
    }
    int len = source.length();
    char achar = 0;
    StringBuffer buffer = new StringBuffer();

    for(int i = 0 ; i < len ;i++) {
      achar = source.charAt(i);
      buffer.append(achar);
      if(achar == symbol) {
        buffer.append(appendSymbol);
      }
    }
    return buffer.toString();
  }

   public static String[] parseClassPath(String classPath , String delim) {
    int index = classPath.indexOf(delim);
    if(index != -1) {
      ArrayList list = new ArrayList();
      int index1 = 0;
      String temp = null;

      while(index != -1) {
        temp = classPath.substring(index1 , index);
        if(temp.length() != 0) {
          list.add(temp);
        }
        index1 = index + 1;
        index = classPath.indexOf(delim , index1);
      }
      if(!classPath.endsWith(delim)) {
        temp = classPath.substring(index1);
        if(temp.length() != 0) {
          list.add(temp);
        }
      }
      String[] res = new String[list.size()];
      list.toArray(res);
      return res;
    } else {
      return new String[]{classPath};
    }
  }

  public static void serializeToFile(Object object , File file) throws Exception {
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    ObjectOutputStream oos = new ObjectOutputStream(baos);
    oos.writeObject(object);
    oos.close();
    byte[] b = baos.toByteArray();
    FileOutputStream fos = new FileOutputStream(file);
    fos.write(b);
    fos.close();
  }

  public static Object deserializeFromFile(File file) throws Exception {
    ByteArrayOutputStream baos = new ByteArrayOutputStream();

    byte[] b = new byte[1024];
    FileInputStream fis = new FileInputStream(file);
    int readed = 0;
    while(true) {
      readed = fis.read(b);
      if(readed == -1) break;
      baos.write(b , 0 , readed);
    }
    baos.close();
    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
    ObjectInputStream ois = new ObjectInputStream(bais);
    fis.close();
    Object result = ois.readObject();
    ois.close();
    return result;
  }
  public static Object deserializeFromFile(File file , final ClassLoader loader) throws Exception {
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    byte[] b = new byte[1024];
    FileInputStream fis = new FileInputStream(file);
    int readed = 0;
    while(true) {
      readed = fis.read(b);
      if(readed == -1) break;
      baos.write(b , 0 , readed);
    }
    baos.close();
    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
    ObjectInputStream ois = new ObjectInputStream(bais) {
      public Class resolveClass(ObjectStreamClass osc) throws IOException , ClassNotFoundException {
        return loader.loadClass(osc.getName());
      }

    };
    fis.close();
    Object result = ois.readObject();
    ois.close();
    return result;
  }

  public static void replaceValuesWith(Properties p , Properties variables) {
    Enumeration source = p.keys();
    String[] vars = new String[variables.size()];
    Enumeration e = variables.keys();
    for (int i = 0; i < vars.length ;i++ ) {
      vars[i] = (String)e.nextElement();
    }
    String key = null;
    String value = null;
    String var = null;
    int prevIndex = 0;
    int index = -1;
    StringBuffer buf = new StringBuffer(70);
    while (source.hasMoreElements()) {
      key = (String)source.nextElement();
      value = p.getProperty(key);
      for (int i = 0; i < vars.length ;i++ ) {
        var = vars[i];
        int l = var.length();
        buf.delete(0 , buf.length());
        prevIndex = 0;
        while(true) {
          index = value.indexOf(var , prevIndex);
          if (index == -1) {
            buf.append(value.substring(prevIndex));
            break;
          }
          if (index == 0) {
            buf.append(variables.getProperty(var));
            prevIndex = l;
            continue;
          }
          buf.append(value.substring(prevIndex , index));
          buf.append(variables.getProperty(var));
          prevIndex = l + index;
//          buf.append(value.substring(index , prevIndex));
        }
        value = buf.toString();
      }
      p.put(key , value);
    }
  }

  public static String getTimeString() {
    Calendar cal = Calendar.getInstance();
    return "" + cal.get(Calendar.HOUR_OF_DAY)  + ":" + cal.get(Calendar.MINUTE) + ":" + cal.get(Calendar.SECOND);
  }

  public static long getTimeLong() {
    return System.currentTimeMillis();
  }

  /* public static void main(String[] args)
  {
    long l = 65*60*1000 + 45*1000 + 3485;
    String[] strBuf = getTimeString(l);
     for (int i = 0 ; i < strBuf.length ; i ++){
       System.out.println(">" + strBuf[i]);
     }
    System.out.println(formatString(strBuf, new String("##h ##' ##.##''"), "0"));
  }
         */


  public static String formatString(String[] strArr, String template, String missingSimbol) {

    // number of the template sumbols for every one char
    int counter = 0;
    // index of the strArr array
    int indexArr = 0;
    int flag = 0;
    if(strArr == null) { // in a case of n/a mode (some problems in invoke methods , or in )
      return "n/a";
    }
    StringBuffer strResult = new StringBuffer();
    template = template + " ";
    for(int i= 0; i< template.length(); i++) {
      char character = template.charAt(i);
      if (character == '#') {
         flag = 0;
         counter++;
      } else {
        if (flag == 0) {
          int len = strArr[indexArr].length();
          if (len<=counter) {
            for(int j=0; j<(counter-len); j++) {
              strResult.append(missingSimbol);
            }
          }
          strResult.append(strArr[indexArr]);
          indexArr++;
          flag++;
        }
        if (i<template.length()-1) {
          strResult.append(character);
        }
        counter = 0;
      }
    }
    return strResult.toString();
  }

  /*
   time - msec
  */
  public static String[] getTimeString(long time) {
    time += 500;
    int msec = 0;
    int sec = 0;
    int min = 0;
    int hour = 0;
    if (time == -1) {
      return null;
    }
    if(time < 1000) {
      msec = (int)time;
    } else {
      long temp = time/1000;//all seconds

      msec = (int)(time%1000);//mls seconds
//System.out.println("MilisecondsMinutes " + msec);
      sec = (int)temp%60;
//System.out.println("Seconds " + sec);

      temp = temp/60;

      min = (int)temp%60;
//System.out.println("Minutes " + min);
      temp = temp/60;
      hour = (int)temp;
//System.out.println("Hour " + hour);
    }
    return new String[]{hour+"" , min+"", sec+"" , msec+""};
  }





  public static String getTime() {
    Calendar cal = Calendar.getInstance();
    int d =  cal.get(Calendar.DAY_OF_MONTH);
    int m = cal.get(Calendar.MONTH) + 1;
    int y = cal.get(Calendar.YEAR);
    return "" + ((m > 9) ? ( "" + m  ) : ("0" + m)) + "." + ((d > 9) ? ("" + d ): ("0" + d)) + "." +y;
  }
  public static boolean isExcluded(Properties excludes,File pathFile , File homeFile) {
    Enumeration e = excludes.keys();
    String key;
    for (;e.hasMoreElements();) {
      key = (String)e.nextElement();

//System.out.println(" Key : "+key);
//System.out.println(" PathFile : "+pathFile);
      if (new File(homeFile , excludes.getProperty(key)).equals(pathFile)) {
//System.out.println(" TRUE ");
        return true;
      }
    }
//System.out.println(" FALSE ");
    return false;
  }

  public static String[] getDateAndTime() {
    Calendar calendar = Calendar.getInstance();
    StringTokenizer dateTokenizer = new StringTokenizer((new Date()).toString());
    String[] dateTokens = new String[dateTokenizer.countTokens()];
    for(int i = 0; i < dateTokens.length; i++) {
      dateTokens[i] = dateTokenizer.nextToken();
    }
    String[] result = {dateTokens[1] + " " + dateTokens[2] + " " + dateTokens[5], dateTokens[3].substring(0, dateTokens[3].lastIndexOf(':')) + " " + (calendar.get(Calendar.AM_PM) == Calendar.AM ? "am" : "pm")};
    return(result);
  }


  public static String exceptionToString(Throwable th) {
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    PrintWriter pw = new PrintWriter(out,true);
    th.printStackTrace(pw);
    pw.flush();
    String exceptionStackTrace = new String(out.toByteArray());
    pw.close();
    return exceptionStackTrace;
  }


  public static void delTree(File fileTree , boolean delRoot) {
    if (fileTree.isFile()) {
      try {
        fileTree.delete();
      } catch(Exception ex) {
        CommonLog.log(ex);
      }
    } else {
      File[] childs = fileTree.listFiles();
      if (childs == null) {
        return;
      }
      for (int i=0;i<childs.length;i++) {
        delTree(childs[i],true);
      }
      if (delRoot) {
        fileTree.delete();
      }
    }
  }
  public static void copyFiles(File source , File destination) throws Exception {
    if(source.isFile()) {
      FileInputStream in = new FileInputStream(source);
      FileOutputStream out = new FileOutputStream(destination);
      byte[] b = new byte[1024];
      int readed = -1;
      try {
        while(true) {
          readed = in.read(b);
          if (readed == -1) break;
          out.write(b , 0 , readed);
        }
      } catch(Exception e){
        in.close();
        out.close();
        throw e;
      }
      in.close();
      out.close();
    } else {
      destination.mkdirs();
      File[] files = source.listFiles();
      if (files == null) {
         throw new IOException("Problem listing directory files!");
      }
      File f;
      for (int i =0 ; i < files.length ; i++ ) {
        f = files[i];
        copyFiles(f , new File(destination.getPath() + File.separator + f.getName()));
      }
    }
  }


  public static void extractArchive(File root , byte[] bytes) throws IOException {
    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
    ZipInputStream zipin = new ZipInputStream(bais);
    ZipEntry entry = zipin.getNextEntry();
    String name = null;
    byte[] b = new byte[2048];
    while(entry != null) {
      name = entry.getName();
      int readed = 0;
      try{
        File f = new File(root , name.replace('/' , File.separatorChar));
        File parent = f.getParentFile();
        if(!parent.exists()) {
          parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(f);
        while(true) {
          readed = zipin.read(b);
          if(readed == -1) break;
          out.write(b , 0 , readed);
        }
        out.close();
      } catch(Exception exc) {
        exc.printStackTrace();
      }
      zipin.closeEntry();
      entry = zipin.getNextEntry();
    }
    zipin.close();
  }

  public static void readToWriteStreams(InputStream in , OutputStream out , int buffSize) throws Exception {
    byte[] b = new byte[buffSize];
    int readed = 0;
    while(true) {
      readed = in.read(b);
      if(readed == -1) break;
      out.write(b , 0 , readed);
    }
  }


  public static void extractArchive(File root , File archive) throws IOException {
    FileInputStream bais = new FileInputStream(archive);
    ZipInputStream zipin = new ZipInputStream(bais);
    ZipEntry entry = zipin.getNextEntry();
    String name = null;
    while(entry != null) {
      name = entry.getName();
      try{
        File f = new File(root , name.replace('/' , File.separatorChar));
        if(entry.isDirectory()){
          f.mkdirs();
        } else {
          File parent = f.getParentFile();
          if(!parent.exists()) {
            parent.mkdirs();
          }
          FileOutputStream out = new FileOutputStream(f);
          readToWriteStreams(zipin , out , 2048);
          out.close();
        }
      } catch(Exception exc) {
        exc.printStackTrace();
      }
      zipin.closeEntry();
      entry = zipin.getNextEntry();
    }
    zipin.close();
  }

  public static Properties mergeWithDefaultProps(Properties defaultProps , Properties p) {
    Enumeration keys = p.keys();
    Properties defClone = (Properties)defaultProps.clone();
    String key = null;
    while (keys.hasMoreElements()) {
      key = (String) keys.nextElement();
      defClone.setProperty(key , p.getProperty(key));
    }
    return defClone;
  }

  public static Object runAction(long timeout, TimeoutAction ta) throws ActionTimeoutException {
    final Object sync = new Object();
    ThreadHelper thread = null;
    try {
      synchronized (sync) {
        thread = new ThreadHelper(ta , sync);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        thread.start();

        if (timeout  == 0 ) {
          return thread.getResult();
        }
        sync.wait(timeout);
        if(thread.isNotified()) {
          Throwable th = thread.getError();
          if(th != null) {
            //th.printStackTrace();
          }
          return thread.getResult();
        } else {
          thread.stop();
          throw new ActionTimeoutException();
        }
      }
    } catch(Exception ex) {
      if ((ex instanceof InterruptedException) && (thread!= null)) {
        thread.stop();
      }
      throw new ActionTimeoutException(ex);
    }

  }

}

class ThreadHelper extends Thread {

  private boolean isNotified = false;
  private TimeoutAction ta;
  private Object sync;
  private Object result;
  private Throwable exc;

  public ThreadHelper(TimeoutAction ta , Object sync) {
    this.ta = ta;
    this.sync = sync;
  }

  public void run() {
    try {
      result = ta.run();
    } catch(Throwable ex) {
      this.exc = ex;
    } finally {
      synchronized(sync){
        isNotified = true;
        sync.notify();
      }
    }
  }

  public Throwable getError() {
    return exc;
  }

  public Object getResult() {
    return result;
  }

  public boolean isNotified() {
    return isNotified;
  }



}