package com.inqmy.ats.system.tools;

import java.io.*;
import java.util.zip.ZipOutputStream;
import java.util.zip.ZipEntry;

/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 
 */
public class SerializableFile implements Serializable {

  private byte[] source;
  private boolean isFile;
  private boolean isArchived;

  public byte[] getSourceBytes() {
    return source;
  }
  //if directory is passed then it is archived
  public void setSourceBytes(File file) throws IOException {
    if(file.isFile()) {
      isArchived = false;
      FileInputStream in = new FileInputStream(file);
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      int readed = 0;
      byte[] b = new byte[1024];
      while (true) {
        readed = in.read(b);
        if(readed == -1 )break;
        baos.write(b , 0 , readed);
      }
      baos.flush();
      source = baos.toByteArray();
      baos.close();
      in.close();
    } else {
      isArchived = true;
      source = getArchiveBytes(file);
    }
  }

  public boolean isFile() {
    return isFile;
  }

  public void setFileStatus(boolean file) {
    isFile = file;
  }

  public boolean isArchived() {
    return isArchived;
  }

  //makes zip archive
  private byte[] getArchiveBytes(File file) throws IOException {
    byte[] res = null;
    if(file.isFile()) {
      FileInputStream in = new FileInputStream(file);
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      int readed = 0;
      byte[] b = new byte[1024];
      while (true) {
        readed = in.read(b);
        if(readed == -1 )break;
        baos.write(b , 0 , readed);
      }
      baos.flush();
      res = baos.toByteArray();
      baos.close();
      in.close();
    } else {
      ArchiveMaker archiver = new ArchiveMaker();
      res = archiver.makeArchive(file);
    }
    return res;
  }
}

class ArchiveMaker {

  private ZipOutputStream out;
  private ByteArrayOutputStream baos;
  private String string;
  private int rootLength = 0;

  public byte[] makeArchive(File file)  throws IOException{
    rootLength = file.getCanonicalPath().replace(File.separatorChar  , '/').length();
    string = null;
    baos = new ByteArrayOutputStream();
    out = new ZipOutputStream(baos);
    make(file);
    out.flush();
    out.finish();
    baos.flush();
    byte[] res = baos.toByteArray();
    out.close();
    return res;
  }

  private void make(File fList) throws IOException {
   if (fList.isFile()) return;
   File[] files = fList.listFiles();
   for (int i = 0; i < files.length ; i++){
     if ( ( files[i].isFile() ) ) {
        putInJar(files[i]);
     } else {
       make(files[i]);
     }
   }
  }

  private void putInJar(File file) throws IOException {
    string = file.getCanonicalPath().replace(File.separatorChar , '/');
    string = string.substring(rootLength + 1);
    out.putNextEntry(new ZipEntry(string));
    FileInputStream in = new FileInputStream(file);
    byte[] byteArr = new byte[2048];
    int readedBytes = 0;
    while ( readedBytes != - 1) {
      readedBytes = in.read(byteArr);
      if (readedBytes != -1) {
        out.write(byteArr,0,readedBytes);
      }
      out.flush();
    }
    in.close();
  }
}

