package com.inqmy.ats.system.tools;

import com.inqmy.ats.system.communication.RemoteInvokeException;
import com.inqmy.ats.system.communication.client.CommunicationContext;
import com.inqmy.ats.system.CoreContext;

import java.util.Hashtable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

/**
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class RemoteStreamImpl implements RemoteStream {

  private Hashtable inputStreams;
  private Hashtable outputStreams;
  private File root;

  public RemoteStreamImpl(File root) {
    inputStreams = new Hashtable();
    outputStreams = new Hashtable();
    this.root = root;
  }
  public RemoteOutputStream getRemoteOutputStream(String path) throws RemoteInvokeException {
    try {
      File f = new File(root , path.replace('/' , File.separatorChar));
      if(!f.getParentFile().exists()) {
        f.getParentFile().mkdirs();
      }
      RemoteOutputStreamImpl ros = new RemoteOutputStreamImpl(new FileOutputStream(f.getCanonicalFile()));
      String name = String.valueOf("remote_output_stream" + ros.hashCode());
      ros.setName(name);
      synchronized(this) {
        Object o = outputStreams.get(name);
        if(o != null) {
          //bad ... close stream.
          //there are two object with same hashcode!!!!!
          CommunicationContext cc = CoreContext.getCommunicationContext();
          cc.unregisterObject(name);
        }
      }
      outputStreams.put(name , ros);
      CommunicationContext cc = CoreContext.getCommunicationContext();
      cc.registerObject(name , ros);
      return (RemoteOutputStream)cc.getProxy(name);
    } catch (Exception exc) {
      throw new RemoteInvokeException(exc.getMessage() , exc);
    }

  }
  public void releaseOutputStream(String streamName) throws RemoteInvokeException {
    try {
      CommunicationContext cc = CoreContext.getCommunicationContext();
      RemoteOutputStream ris = (RemoteOutputStream)outputStreams.remove(streamName);
      if(ris == null) {
        throw new RemoteInvokeException("No such stream!!");
      }
      cc.unregisterObject(streamName);
    } catch(Exception exc) {
      throw new RemoteInvokeException(exc.getMessage() , exc);
    }

  }

  public RemoteInputStream getRemoteInputStream(String path) throws RemoteInvokeException {
    try {

      RemoteInputStreamImpl ris = new RemoteInputStreamImpl(new FileInputStream(new File(root , path.replace('/' , File.separatorChar)).getCanonicalFile()));
      String name = String.valueOf("remote_input_stream" + ris.hashCode());
      ris.setName(name);
      synchronized(this) {
        Object o = inputStreams.get(name);
        if(o != null) {
          //bad ... close stream.
          //there are two object with same hashcode!!!!!
          CommunicationContext cc = CoreContext.getCommunicationContext();
          cc.unregisterObject(name);
        }
      }
      inputStreams.put(name , ris);
      CommunicationContext cc = CoreContext.getCommunicationContext();
      cc.registerObject(name , ris);
      return (RemoteInputStream)cc.getProxy(name);
    } catch (Exception exc) {
      throw new RemoteInvokeException(exc.getMessage() , exc);
    }
  }

  public void releaseInputStream(String streamName) throws RemoteInvokeException {
    try {
      CommunicationContext cc = CoreContext.getCommunicationContext();
      RemoteInputStream ris = (RemoteInputStream)inputStreams.remove(streamName);
      if(ris == null) {
        throw new RemoteInvokeException("No such stream!!");
      }
      cc.unregisterObject(streamName);
    } catch(Exception exc) {
      throw new RemoteInvokeException(exc.getMessage() , exc);
    }
  }

}
