package com.inqmy.ats.system.tools;

import com.inqmy.ats.system.communication.RemoteInvokeException;

/**
 * This interface has to be implemented from class that will
 * provide methods for getting streams for writing and reading of file data
 * from file system. This class will manage streams and has response for
 * registering them for remote calls.
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public interface RemoteStream {
  /**
   * Returns remote stream for reading from remote source data.
   * Path is relative from remote root directory of remote
   * virtual file system. The source is physical file on remote host.
   *
   * @param path path to source.
   * @return remote stream for reading from source.
   * @throws RemoteInvokeException
   */
  public RemoteInputStream getRemoteInputStream(String path) throws RemoteInvokeException;
  /**
   * Returns remote stream for writing to remote source.
   * Path is relative from remote root directory of remote
   * virtual file system. The source is physical file on remote host.
   *
   * @param path path to source.
   * @return remote stream for writing from source.
   * @throws RemoteInvokeException
   */
  public RemoteOutputStream getRemoteOutputStream(String path) throws RemoteInvokeException;

  public void releaseInputStream(String streamName) throws RemoteInvokeException;
  public void releaseOutputStream(String streamName) throws RemoteInvokeException;
}
