package com.inqmy.ats.system.tools;

import com.inqmy.ats.system.communication.RemoteInvokeException;

import java.io.OutputStream;

/**
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class RemoteOutputStreamImpl implements RemoteOutputStream {

  private OutputStream out;
  private String name;

  public RemoteOutputStreamImpl(OutputStream out) {
    this.out = out;
  }
  void setName(String name) {
    this.name = name;
  }
  public void write(byte[] b) throws RemoteInvokeException {
    try {
      out.write(b);
    } catch(Exception exc) {
      throw new RemoteInvokeException("Error write to stream!" , exc);
    }
  }

  public void write(byte[] b, int off, int length) throws RemoteInvokeException {
    try {
      out.write(b , off , length);
    } catch(Exception exc) {
      throw new RemoteInvokeException("Error write to stream!" , exc);
    }
  }

  public void close() throws RemoteInvokeException {
    try {
      out.close();
    } catch(Exception exc) {
      throw new RemoteInvokeException("Error close stream!" , exc);
    }
  }

  public String getName() throws RemoteInvokeException {
    return name;
  }
}
