package com.inqmy.ats.system.tools;

import com.inqmy.ats.system.communication.RemoteInvokeException;

import java.io.InputStream;

/**
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class RemoteInputStreamImpl implements RemoteInputStream {

  private InputStream in;
  private String name;
  private boolean closed = false;

  public RemoteInputStreamImpl(InputStream in ) {
    this.in = in;
  }

  void setName(String name){
    this.name = name;
  }
  public byte[] readBytes(int maxLength) throws RemoteInvokeException {
    byte[] b = new byte[maxLength];
    int readedBytes = 0;
    try {
      int readed = in.read(b);
      readedBytes = readed;
      if(readed == -1) return null;
      while(true) {
        readed = in.read(b , readed , (b.length - readedBytes));
        if(readed == -1) {
          //end of stream.
          break;
        }
        readedBytes += readed;
        if(readedBytes == b.length) {
          break;
        }
      }
    } catch(Exception exc) {
      throw new RemoteInvokeException(exc.getMessage() , exc);
    }
    if(readedBytes != b.length) {
      byte[] bb = new byte[readedBytes];
      System.arraycopy(b , 0 , bb , 0 , readedBytes);
      return bb;
    }
    return b;
  }

  public void close() throws RemoteInvokeException {
    try {
      closed = true;
      in.close();
    } catch(Exception n) {
      throw new RemoteInvokeException(n.getMessage() , n);
    }
  }

  public String getName() throws RemoteInvokeException {
    return name;
  }

  public boolean isClosed() throws RemoteInvokeException {
    return closed;
  }
}
