package com.inqmy.ats.system.tools;

import com.inqmy.ats.system.communication.RemoteInvokeException;

/**
 * Used to read data from remote source when source data is too big
 * for remote transfering of all bytes.
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public interface RemoteInputStream {
  /**
   * Try to read <param>maxLength</param> number of bytes.
   * If there are no more bytes to read then null is returned.
   * If can not read <param>maxLength</param> number of bytes then
   * returned byte[] has length number of bytes that are actually read.
   * @param maxLength maximal length of bytes to read.
   * @return readed bytes.
   * @throws RemoteInvokeException
   */
  public byte[] readBytes(int maxLength) throws RemoteInvokeException;

  /**
   * Close the source InputStream.
   * @throws RemoteInvokeException
   */
  public void close() throws RemoteInvokeException;
  /**
   * Returns unicue name of stream.
   * Used to unregister stream from remote stream factory.
   * @return
   * @throws RemoteInvokeException
   */
  public String getName() throws RemoteInvokeException;

  public boolean isClosed() throws RemoteInvokeException;

}
