package com.inqmy.ats.system.tools;

import com.inqmy.ats.system.communication.RemoteInvokeException;

import java.io.File;
import java.io.IOException;
import java.io.FileOutputStream;

/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 
 */
public class RemoteFileImpl implements RemoteFile {

  private File root = new File(".");

  void setRootDirectory(File root) {
    this.root = root;
  }

  public void upload(SerializableFile file ,  String relativePath) throws RemoteInvokeException {
    try {
      if(file.isFile()) {
        File f = new File(root , relativePath.replace('/' , File.separatorChar));
        File parent = f.getParentFile();
        if(!parent.exists()) {
          parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(f);
        out.write(file.getSourceBytes());
        out.flush();
        out.close();
      } else {
        Utilities.extractArchive(root, file.getSourceBytes());
      }
    } catch (Exception exc) {
      throw new RemoteInvokeException("Error uploading!" , exc);
    }
  }

  public SerializableFile download(String relativePath) throws RemoteInvokeException {
    File f = relativePath.equals(".") ? root : new File(root , relativePath.replace('/' , File.separatorChar));
    if(!f.exists()) {
      throw new RemoteInvokeException("File with relative path "+relativePath+" do not exists!");
    }
    try {
      SerializableFile result = new SerializableFile();
      result.setSourceBytes(f);
      return result;
    } catch(IOException ioexc){
      throw new RemoteInvokeException("",ioexc);
    }
  }

}
