package com.inqmy.ats.system.tools;

import java.util.*;

import java.io.*;

public class PropertiesWrapper implements Serializable {
  
  private Vector ref;
  private Vector back;
  //private Vector listeners;

  private String fileName;
  private String name;
  private String[] prefixes;
  private String[] excludePrefixes;
  private Properties props;
  private Properties runtimeProperties;
  
  private transient PropertiesChangeListener listener;

  //public constructor
  public PropertiesWrapper(String name , String[] prefixes , String[] excludePrefixes , String fileName) {
    this.prefixes = prefixes;
    this.excludePrefixes = excludePrefixes;
    this.fileName = fileName;
    this.name = name;
    this.props = new Properties();
  }

  //--------- public methods -----------
  public String getName(){
    return name;
  }
  public String[] getPrefixes() {
    return prefixes;
  }
  public String[] getExcludePrefixes() {
    return excludePrefixes;
  }
  public String getSourceFileName() {
    return fileName;
  }
  public Properties getSourceProperties() {
    return (Properties)props.clone();
  }
  public Properties getRuntimeProperties() {
    if(runtimeProperties == null) {
      runtimeProperties = (Properties)props.clone();
    }
    return runtimeProperties;
  }
  //sets properties that will be realy used 
//  public void setRuntimeProperties(Properties p) {
//    this.runtimeProperties = p;
//  }
  public void clear() {
    if(runtimeProperties!=null){
      runtimeProperties = null;
    }
    props.clear();
  }
 /* 
  public Object clone() {
    try{
      return super.clone();
    } catch(CloneNotSupportedException e) {
      e.printStackTrace();
      return null;
    }
  }
  */
  //sets real properties
  //when this method is called must change all of referenced runtime properties
  public void setSourceProperties(Properties pr) {
//    flag = true;
    props = pr; 
    notifyReferenced();
  }

  public void addChangeListener(PropertiesChangeListener listener) {
    this.listener = listener;
  }
  public void removeListener() {
    listener = null;
  }
  //called to update runtime properties
  public void updateRuntimeProperties(Properties p) {
    runtimeProperties = (Properties)props.clone();
    Utilities.replaceValuesWith(runtimeProperties , p);
    if(listener != null){
      try{
        listener.notifyChange(this);
      }catch(Exception exc){
        exc.printStackTrace();
      }
    }
  }
  
  void notifyReferenced() {
    if(back != null) {//changes all of PropetiesWrappers that have reference to this
      for (int i = 0 ; i < back.size() ; i++ ) {
        PropertiesWrapper tempW = (PropertiesWrapper)back.elementAt(i);
        Properties temp = tempW.getRuntimeProperties();
        if(temp != null){
          tempW.updateRuntimeProperties(props);
        }
      }
    }
    if(ref != null) {//changes runtimeProperties by replace values with properties that this have reference to
      for (int i = 0 ; i < ref.size() ; i++ ) {
        PropertiesWrapper tempW = (PropertiesWrapper)ref.elementAt(i);
        Properties temp = tempW.getRuntimeProperties();
        if(temp != null ) {
          updateRuntimeProperties(temp );
          return;
        }
      }
    }
    runtimeProperties = (Properties)props.clone();
    if(listener != null){
      try{
        listener.notifyChange(this);
      }catch(Exception exc){
        exc.printStackTrace();
      }
      
    }
    
  }  
  //this methods sets properties which will be used for values in this property object
  void setReferenceTo(PropertiesWrapper pw) {
    if(ref == null){
      ref = new Vector();
    }
    ref.add(pw);
    pw.refAdded(this);
  }
  //called to notify that ref to this is made
   void refAdded(PropertiesWrapper pw) {
    if(back == null) {
      back = new Vector();
    }
    back.add(pw);
  }
  //-----------------------

}
