package com.inqmy.ats.system.tools;

import java.util.*;
import java.io.*;

//this is class for holding and managing all properties that system uses.
//this class have methods for loading and saving properties to file system.
public class PropertiesManager implements Serializable {
  
  private Hashtable hash;

  //public constructor
  public PropertiesManager() {
    hash = new Hashtable();
  }

  //--------- public methods -----------
  public PropertiesWrapper[] getAllProperties() {
    Vector v = new Vector();
    Enumeration e = hash.elements();
    while(e.hasMoreElements()) {
      v.add(e.nextElement());
    }
    PropertiesWrapper[] res = new PropertiesWrapper[v.size()];
    v.copyInto(res);
    return res;
  }
  //method for adding properties information;
  public void add(PropertiesWrapper prop) {
    hash.put( prop.getName() , prop);
  }
  public PropertiesWrapper get(String name) {
    return (PropertiesWrapper)hash.get(name);
  }
  //method for loading registered properties from file system;
  public void loadAll() throws Exception {
    Enumeration e = hash.elements();
    PropertiesWrapper prop = null;
    boolean exc = false;
    Vector temp = new Vector();
    while(e.hasMoreElements()) {
      prop = (PropertiesWrapper)e.nextElement();
      try{
        load(prop);
        temp.add(prop);        
      } catch(Exception ee){
        ee.printStackTrace();
        CommonLog.log("Error loading property : " + prop.getName() +" from file : " + prop.getSourceFileName() + "\n Problem is : " + ee.getMessage() ,com.inqmy.ats.system.Engine.WARNING_MESSAGE);
        exc = true;
      }
    }
    for (int i = 0 ; i < temp.size() ; i++){
      ((PropertiesWrapper)temp.elementAt(i)).notifyReferenced();
    }
    if(exc){
      throw new Exception("Problem loading properties");
    }
  }
  
  public void load(PropertiesWrapper prop) throws Exception {
    String[] prefix  = prop.getPrefixes();
    String[] excPrefix = prop.getExcludePrefixes();
    String file = prop.getSourceFileName();
    Properties properties = loadPropsFromFile( file,  prefix , excPrefix);
//System.out.println(prop.getName() + "----------- SETTING PROPERTIES TO : " + prop + " PROPS ARE : " + properties +"\n-------------");
    prop.setSourceProperties(properties);
  }
  //method for saving property to file system
  public void save(PropertiesWrapper prop) throws Exception {
    Properties p = null;
    String[] excludePrefixes = prop.getExcludePrefixes();
    String[] includePrefixes = prop.getPrefixes();
    Properties temp = prop.getSourceProperties();    
    if(excludePrefixes != null || includePrefixes != null) {
      try {
        p = loadPropsFromFile(prop.getSourceFileName() ,includePrefixes,excludePrefixes );
      } catch(Exception ee){
        ee.printStackTrace();
      }
    } else {
      p = temp;
    }

    if(p == null) {
      p = temp;
    }

    //---- begin fix
    RandomAccessFile raf = new RandomAccessFile(prop.getSourceFileName(), "r");
    StringBuffer bufferr = new StringBuffer((int)raf.length());
    String line = null;

    while(true) {
      line = raf.readLine();
      if(line == null){
        break;
      }
      String tline = line.trim();
      if(tline.startsWith("#") || tline.equals("")) {
        bufferr.append(line + "\r\n");
        continue;
      } else {
        int ind = tline.indexOf("=");
        String key = null;
        String s_value = null;
        if(ind != -1) {
          key = tline.substring(0 , ind).trim();
          s_value =tline.substring(ind + 1).trim();
        } else {
          key = tline;
          s_value = "";
        }
        //p - property which contains source info from file
        String value = p.getProperty(key);
        if(value != null && temp.getProperty(key) == null) {
          //in this case, the key does not exist in runtime property but exists in source file!
        } else if(temp.getProperty(key) != null && value != null) {
          //in this case, the value do exist in source file and exist in runtime properties
          if(!s_value.startsWith("$$")) {
            bufferr.append(key + "=" + temp.getProperty(key) + "\r\n");
          } else {
            bufferr.append(key + "=" + s_value + "\r\n");
          }
          temp.remove(key);
        } else {
          //key is not in property
          bufferr.append(key + "=" + s_value + "\r\n");

        }
      }
    }
    raf.close();
    FileOutputStream out = new FileOutputStream(prop.getSourceFileName());
    Enumeration enum = temp.keys();

    while(enum.hasMoreElements()) {
      String v = (String)enum.nextElement();
      bufferr.append(v +"="+temp.getProperty(v)+"\r\n");
    }
    out.write(bufferr.toString().getBytes());
    out.close();
    // end fix

  }
  public void saveAllProperties() throws Exception {
    Enumeration e = hash.elements();
    PropertiesWrapper pw = null;
    boolean err = false;
    while(e.hasMoreElements()){
      try{
        pw = (PropertiesWrapper)e.nextElement();
        save(pw);
      } catch(Exception exc){
        err = true;
        exc.printStackTrace();
         CommonLog.log("Error saving property : " + pw.getName() +" to file : " + pw.getSourceFileName() + "\n Problem is : " + exc.getMessage() , com.inqmy.ats.system.Engine.WARNING_MESSAGE);
      }
    }
    if(err) {
      throw new Exception("Some of properties can not be saved ");
    }
  }
  public void setReference(PropertiesWrapper from , PropertiesWrapper to) {
    from.setReferenceTo(to);
  }
  //------------------------------------

  //------private methods -----
  private Properties loadPropsFromFile(String file, String[] prefix , String[] excPrefix) throws Exception {
    Properties properties = new Properties();
    FileInputStream in = new FileInputStream(file);
    StringBuffer sb = new StringBuffer(150);
    int ind = -1;
    byte[] b = new byte[512];
    while(true) {
      ind = in.read(b);
      if(ind == -1) break;
      sb.append(new String(b , 0 , ind));
    }
    b = null;
    in.close();
    String string = sb.toString();
    int prevInd = 0;
    ind  = 0;
    String line = null;
    while(ind != -1) {
      ind = string.indexOf('\n' , prevInd +1);
//System.out.println("FROM " + prevInd + " TO  " + (ind == -1 ? string.length() : ind) + " LINE : " + line);
      line = string.substring(prevInd , ind == -1 ? string.length() : ind).trim();
//System.out.println(" LINE : " + line);
      prevInd = ind;
      if(!line.startsWith("#") && !line.equals("")) {
        ind = line.indexOf('=');
        String key = null;
        String value = null;

        if(ind != -1) {
          key = line.substring(0 , ind).trim();
          value = line.substring(ind + 1);
        } else {
          key = line.trim();
          value = "";
        }
        boolean accept = false;
        if(prefix != null) {
          for (int i = 0; i< prefix.length; i++) {
            if(key.startsWith(prefix[i])){
              accept = true;
              break;
            }
          }
          if(accept) {
            properties.setProperty(key , value);
          }
        } else if(excPrefix != null) {
          for (int i = 0; i< excPrefix.length; i++) {
            if(key.startsWith(excPrefix[i])) {
              accept = true;
            }
          }
          if(!accept) {
            properties.setProperty(key , value);
          }
        } else {
          properties.setProperty(key, value);
        }

      }
      ind = prevInd;
    }
    return properties;
  }
  //---------------------------
}