package com.inqmy.ats.system.tools;

import com.inqmy.ats.system.communication.RemoteInvokeException;
import com.inqmy.ats.system.Engine;

/**
 * This class represents logic of logging different types of messages
 * it log messages using System.out output stream.Used when ATS is started
 * in console mode.
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class ConsoleMessageManagerImpl implements MessageManager {

  private String wariningHeader = "----------------------------   WARNING  ----------------------------";
  private String infoHeader     = "----------------------------    INFO    ----------------------------";
  private String errorHeader    = "----------------------------    ERROR   ----------------------------";
  private String endHeader_69   = "--------------------------------------------------------------------";

  public void messageReceived(String message, byte type) throws RemoteInvokeException {
    switch (type) {
      case Engine.FATAL_MESSAGE : {
        System.out.println(errorHeader);
        System.out.println(message);
        System.out.println(endHeader_69);
        break;
      }
      case Engine.WARNING_MESSAGE : {
        System.out.println(wariningHeader);
        System.out.println(message);
        System.out.println(endHeader_69);
        break;
      }
      case Engine.INFO_MESSAGE: {
        System.out.println(infoHeader);
        System.out.println(message);
        System.out.println(endHeader_69);
        break;
      }


      default : break;
    }
  }

}
