package com.inqmy.ats.system.tools;

import com.inqmy.ats.system.Engine;
import com.inqmy.ats.system.CoreContext;
import com.inqmy.ats.boot.Utility;


import java.io.*;
import java.util.Vector;

public class CommonLog {

  public static final String logSystemModeKey = "com.ats.log.mode";


  private static OutputStream out = System.out;

  private static Vector managers = new Vector(2);

  private static LogListener listener;
  private static final String ASCII = "ISO-8859-1";
  private static final String EBCDIC = "Cp1047";
  private static String ENCODING;

  private static String jvm;

  static {
    if(Boolean.getBoolean("ebcdic.platform")) {
      ENCODING = EBCDIC;
    } else {
      ENCODING = ASCII;
    }
  }

  public static void setOutput(OutputStream outStream) {
    out = outStream;
  }

  //this method adds a MessageManager that is responsible for managing messages with specefied type
  public static void addMessageManager(MessageManager mManager) {
    managers.add(mManager);
  }

  public static void log(String str)  {
    if (jvm == null) {
      jvm = "[" + CoreContext.getJVMname() + "] ";
    }
    try {
      out.write((jvm + str ).getBytes(ENCODING));
      if(listener!= null){
        listener.log(str);
      }
    } catch(Exception e){}

  }

  public static void log(Throwable t) {
    if (jvm == null) {
      jvm = "[" + CoreContext.getJVMname() + "] ";
    }
    try {
      String throwable = Utilities.exceptionToString(t);
      out.write(( jvm + throwable + "\n").getBytes(ENCODING));
      if(listener!= null){
        listener.log(throwable);
      }
    } catch(Exception e){}

  }

  public static void log(String message , byte type,  int logMode) {
    log(message);
    if (!((type == Engine.WARNING_MESSAGE) && ((logMode==Utility.LOW_LEVEL_MODE) || (logMode==Utility.TRACE_MODE)))) {
      for (int i = 0 ; i < managers.size() ; i++) {
        MessageManager mm = (MessageManager) managers.elementAt(i);
        if(mm != null) {
          try {
            mm.messageReceived(message , type);
          } catch(Exception exc){}
        }
      }
      try {
        if (listener!= null) {
          listener.log(message , type);
        }
      } catch(Exception esx){}
    }
  }


  /**
   * Deprecated method. it throws Exception if is used.
   * @param message
   * @param type
   */
  public static void log(String message , byte type) {
    //throw new Exception("Deprecated!");
    log(message);
    for (int i = 0 ; i < managers.size() ; i++) {
      MessageManager mm = (MessageManager) managers.elementAt(i);
      if(mm != null) {
        try {
          mm.messageReceived(message , type);
        } catch(Exception exc){}
      }
    }
    try {
      if (listener!= null) {
        listener.log(message , type);
      }
    } catch(Exception esx){}
  }



  //this methods set LogListener which is used as tunneling of messages that are loged through CommonLog methods.
  //it is used mainly for remote logging.
  public static void setLogListener(LogListener l) {
    listener = l;
  }
}