package com.inqmy.ats.system.communication.protocol;

import com.inqmy.ats.system.communication.Connection;

/**
 * Protocol specification interface.
 * 
 * 
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public interface Protocol {
  
  //process information that is coded in header array
  public void processHeader(byte[] b , Connection con);
  
  //return protocol header length
  public int getHeaderLength();

  public Object call(String registeredObjectName , int methodIndex, Object[] params, Connection con) throws Exception;

  public void connectionClosed(Connection con);
}