/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
package com.inqmy.ats.system.communication.impl0;

import com.inqmy.ats.system.tools.CommonLog;
import com.inqmy.ats.boot.Utility;
import com.sap.tc.logging.Location;

public class ThreadPool {

  private int threadCount = 1;
  private ThreadWork[] threads;
  private int[] freeIds;
  private int last=0;

  private static Location location = Location.getLocation(ThreadPool.class);

  public void start(Runnable r) throws Exception {
    ThreadWork tw = getFree();
    tw.setWork(r);
  }

  public ThreadPool() throws Exception {
    intialize();
  }

  private void intialize() throws Exception {
    threads = new ThreadWork[threadCount];
    freeIds = new int[threadCount];
    for (int i = 0 ; i < threadCount; i++) {
      threads[i] = new ThreadWork(this , i);
      freeIds[i] = i;
    }
    last = threadCount;
  }

  private synchronized ThreadWork getFree() throws Exception {
    if(last == 0) {//no free Threads
      int tt = threadCount*2;
location.debugT("[Connection manager] Resizing thread pool(old length : " + threadCount + " new length : " +tt +")");
      freeIds = new int[tt];
      last = threadCount - 1;
      ThreadWork[] temp = new ThreadWork[tt];
      System.arraycopy(threads , 0 , temp , 0 , threadCount);
      threads = temp;
      for (int i = threadCount ; i < tt; i++) {
        threads[i] = new ThreadWork(this , i);
        freeIds[i - threadCount] = i;
      }
      threadCount = tt;
      return threads[tt -1];
    } else {
      --last;
      return threads[freeIds[last]];
    }
  }

  synchronized void finished(ThreadWork thread){
    //returns to free
    int id = thread.getId();
    freeIds[last++] = id;
  }
}

class ThreadWork extends Thread {

  private Runnable r;
  private ThreadPool pool;
  private boolean working = true;
  private boolean flag = false;
  private int id;

  public ThreadWork(ThreadPool pool , int id) throws Exception {
    this.pool = pool;
    this.id =  id;
    this.start();
    synchronized(this) {
      if(working) {
        wait();
      }
    }
  }

  public void run() {
    try {
      while(!flag) {
        synchronized (this) {
          working = false;
          notify();
          if(r == null) {
            wait();
          }
          working = true;
        }
        try {
          r.run();
        } catch(Throwable thr) {
          thr.printStackTrace();
        }
        synchronized (this) {
          r = null;
          if(!flag) {
            pool.finished(this);
          }
        }
      }
    } catch (Exception exc) {
      exc.printStackTrace();
    }
  }

  public void setWork(Runnable r) {
    synchronized(this) {
      this.r = r;
      notify();
    }
  }

  public int getId() {
    return id;
  }
  public void disable() {
    flag = true;
  }
}
