package com.inqmy.ats.system.communication.impl0;

import java.io.*;
import java.lang.reflect.*;

import com.inqmy.ats.system.communication.Connection;
import com.inqmy.ats.system.communication.client.Proxy;
import com.inqmy.ats.system.communication.ObjectStore;
import com.inqmy.ats.system.communication.RemoteInvokeException;
import com.inqmy.ats.system.tools.CommonLog;

/**
 * Thread for processing calls
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public class ProtocolProcessor  implements Runnable {

  private Message message;
  private ProtocolImpl protocol;
  private byte[] bodyArray;
  private Connection con;

  public ProtocolProcessor( ProtocolImpl protocol , Message message ,byte[] bodyArray , Connection con ) {
    this.con = con;
    this.protocol = protocol;
    this.bodyArray = bodyArray;
    this.message = message;
  }

    public void run() {
    //processes header
    switch (message.getType()) {
      //body of message contains in specefied order :
      //1 : String = registered name of object
      //2 : int = index of method for call in method array
      case ProtocolImpl.CALL_REQUEST_MESSAGE : {
        try {
          byte[] resultBytes = null;
          //geeting new Stream for  deserializing
          ObjectSerializator ser = ObjectSerializator.getSerializator();
          ObjectInputStream ois = ser.getObjectInputStream(bodyArray);
          //reads name of object
          String name = (String)ois.readObject();
          //reads index of method array
          int methodIndex = ois.readInt();
          //verifies that there is registered such object
          Method method = null;
          Object[] params = null;
          try {
            method = ObjectStore.getMethodFor(name , methodIndex);
            try {
              params = (Object[])(ois.readObject());
              if(params != null){
                for(int i = 0 ; i < params.length; i++) {
                  //check parameter classes , if it is a proxy instance then it is considered for proper proxy object.
                  //it is registered on VM that makes current call
                  //it have to make remote calls through itself as it is got from local method of CommunicationContext getProxy(String name).
                  if(params[i] instanceof com.inqmy.ats.system.communication.client.Proxy) {
                    //for every passed proxy instance have to set id of connection to remote VM
                    ((Proxy)params[i]).setConnectionId(con.getId());
                  }
                }
              }
            } catch(Throwable thr) {
              //thrown is some kind of problems during deserializing prameter for methof invokation
              //possible problem with class loader for communication.
              thr.printStackTrace();
              System.out.println(method.getName() + ">>>>>> " + name + " >>>>>> " + method.getDeclaringClass());
              resultBytes = ser.serializeObject(new RemoteInvokeException("Error deserializing parameters fro method invokation!",thr));
            }
          } catch(Exception uexc) {
            CommonLog.log(uexc);
            //thrown if object with such name is unregistered
            resultBytes = ser.serializeObject(new RemoteInvokeException("Object with name : " + name + " have been unregistered!",uexc));
          }
          if(resultBytes == null) {
            try {
              //the real part of method call.
              Object result  = method.invoke(ObjectStore.getObject(name) , params);
              resultBytes = ser.serializeObject(result);

            } catch(InvocationTargetException ite) {
              //method returns error from it's execution
              resultBytes = ser.serializeObject(new RemoteInvokeException("Error invoke method!",ite.getTargetException()));
            } catch(IllegalAccessException iaexc) {
              resultBytes = ser.serializeObject(new RemoteInvokeException("Error invoke method!IllegalAccessException!",iaexc));
            }
          }
          //makes response message and sends it to calling VM.
          //in this case connection problems can occures
          Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , resultBytes.length);
          con.writeMessageAndBody(Parser.getBytes(resultMessage) , resultBytes);
        } catch(Throwable exc) {
          //connection problems or communication protocol INCONGRUITY
          //1 - in case of connection problems connection unregisters itself,so here no need to care about it.
          //2 - in case of protocol INCONGRUITY we have to close connection so here have to call close() meethod
          //if connection allready have been closed then nothing is done.the method is synchronized so double unregistering is imposible
          con.close();
System.out.println("[Connection Manager] Error with call request proccessing.Possible lost of connection or error in protocol INCONGRUITY.Problem is : ");

          exc.printStackTrace();
        }
        break;
      }
      //this message is send from client to server in order to register object with specefied name
      //in other words notify server that object has been registered on client (client JVM)
      // message contains (in specefied order) :
      //1 : String = register name for object
      //2 : String = class name of proxy object
      case ProtocolImpl.REGISTER_REQUEST_MESSAGE : {
        String name = null;
        String proxyClassName = null;
        try {
          ObjectSerializator ser = ObjectSerializator.getSerializator();
          ObjectInputStream ois = ser.getObjectInputStream(bodyArray);
          name = (String)ois.readObject();//name to register
          proxyClassName = (String)ois.readObject();//name of proxy class
          ois.close();
        } catch(Throwable thr) {
          // protocol error , close connection
          con.close();
          break;
        }
        try {
          //registers object in current JVM
          protocol.getContext().registerProxyObject(name , proxyClassName , con.getId());
        } catch(Throwable exc) {
          //thrown if :
          //1 - there is allready registered object with specefied name
          //2 - there is problem with proxy class loading or instantiation of it
          try {
            ObjectSerializator ser = ObjectSerializator.getSerializator();
            byte[] resultBytes = ser.serializeObject(new RemoteInvokeException("Error registering object with name : " + name, exc));
            Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , resultBytes.length);
            con.writeMessageAndBody(Parser.getBytes(resultMessage) , resultBytes);
          } catch(Exception e) {
            //connection error do nothing in this case connection take care of it's own problem
            e.printStackTrace();
          }
          break;
        }
        //all passed without problem OK
        try {
          ObjectSerializator ser = ObjectSerializator.getSerializator();
          byte[] resultBytes = ser.serializeObject("OK");
          //sends String OK :))))
          Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , resultBytes.length);
          con.writeMessageAndBody(Parser.getBytes(resultMessage) , resultBytes);
        } catch(Exception e) {
          //connection error do nothing in this case connection take care of it's own problem
          e.printStackTrace();
        }
        break;
      }
      //remote message for unregister is send and now have to unregister object
      case ProtocolImpl.UNREGISTER_REQUEST_MESSAGE : {
        String name = null;
        try {
          ObjectSerializator ser = ObjectSerializator.getSerializator();
          ObjectInputStream ois = ser.getObjectInputStream(bodyArray);
          name = (String)ois.readObject();//name to unregister
          ois.close();
        } catch(Throwable thr) {
          // protocol error , close connection
          con.close();
          break;
        }
        try {
          //unregister object with specefied name

          protocol.getContext().unregisterRemoteObject(name , con.getId() , ProtocolImpl.UNREGISTER_REQUEST_MESSAGE);
        } catch(Throwable exc) {
          //error unregistering object now sends exception to calling JVM
          try {
            ObjectSerializator ser = ObjectSerializator.getSerializator();
            RemoteInvokeException riexc = (exc instanceof RemoteInvokeException) ? (RemoteInvokeException)exc : new RemoteInvokeException("Error unregistering object with name : " + name, exc);
            byte[] resultBytes = ser.serializeObject(riexc);
            Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , resultBytes.length);
            con.writeMessageAndBody(Parser.getBytes(resultMessage) , resultBytes);
          } catch(Exception e) {
            //connection error do nothing in this case connection take care of it's own problem
            e.printStackTrace();
          }
          break;
        }
        try {
          ObjectSerializator ser = ObjectSerializator.getSerializator();
          byte[] resultBytes = ser.serializeObject("OK");
          //sends String OK :))))
          Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , resultBytes.length);
          con.writeMessageAndBody(Parser.getBytes(resultMessage) , resultBytes);
        } catch(Exception e) {
          //connection error do nothing in this case connection take care of it's own problem
          e.printStackTrace();
        }
        break;
      }
      //this message is send from client to server.It asks server if there is registered object with specefied name
      //if there is no such object then exception is returns to client
      case ProtocolImpl.ASK_FOR_PROXY_REQUEST_MESSAGE : {
        try {
          ObjectSerializator ser = ObjectSerializator.getSerializator();
          ObjectInputStream ois = ser.getObjectInputStream(bodyArray);
          String name = (String)ois.readObject();//name of registered object
          String ss = null;
          Object pobj = ObjectStore.getObject(name);
          if(pobj != null) {
            ss = pobj.getClass().getName();
          } else {
             throw new Exception("No registered object with name : " + name);
          }
          ser.clear();
          ser.addObject(ss);
          ser.addObject(((Proxy)pobj).getObjectRegisteredName());
          byte[] array = ser.getCurrentBytes();
          Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , array.length);
          con.writeMessageAndBody(Parser.getBytes(resultMessage) , array);
          ois.close();
        } catch(Exception e){
          try{
            ObjectSerializator ser = ObjectSerializator.getSerializator();
            byte[] resultBytes = ser.serializeObject(new RemoteInvokeException("Error in getting proxy" , e));
            Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , resultBytes.length);
            con.writeMessageAndBody(Parser.getBytes(resultMessage) , resultBytes);
          } catch(Exception exc){
            exc.printStackTrace();
          }
          //e.printStackTrace();
        }
        break;
      }
      //this message is sent from client to server. Notify that listener on client is registered.
      //server will use this connection to notify client that object is registered/unregistered
      case ProtocolImpl.REGISTER_LISTENER_MESSAGE : {
        //here server must add this connection to listener store. It will be used for notification of listeners that are on client.
        protocol.getContext().addListener(con);
        try {
          byte[] array = new byte[0];
          Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , array.length);
          con.writeMessageAndBody(Parser.getBytes(resultMessage) , array);
       } catch(Exception e) {
          //connection error do nothing in this case connection take care of it's own problem
          e.printStackTrace();
        }
        break;
      }
      //this message is sent from client to the server. Notify that listener should be unregistered.
      case ProtocolImpl.UNREGISTER_LISTENER_MESSAGE : {
        try {
          protocol.getContext().removeListener(con);
        } finally {
          try {
            byte[] array = new byte[0];
            Message resultMessage = new Message(ProtocolImpl.ANSWER_MESSAGE , message.getCallId()  , array.length);
            con.writeMessageAndBody(Parser.getBytes(resultMessage) , array);
          } catch(Exception e) {
            //connection error do nothing in this case connection take care of it's own problem
            e.printStackTrace();
          }
        }
        break;
      }

      default : break;

    }
  }

}