package com.inqmy.ats.system.communication.impl0;

import com.inqmy.ats.system.communication.*;
import java.lang.reflect.*;
 
/**
 * Class that represents protocol coding.
 * 
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public class Parser {
  
  static final int INTFLAG = 0x000000ff;

  public synchronized static Message getMessage(byte[] b) {
    int ind = ProtocolImpl.PROTOCOL_NAME.length;
    
    Message res = new Message(b[ind] ,getInt(b , ind + 1) , getInt(b , ind + 5) );
    
    return res;
  }

  public synchronized static byte[] getBytes(Message message) {
    byte[] res = new byte[ProtocolImpl.PROTOCOL_HEADER_LENGTH];
    byte[] name = ProtocolImpl.PROTOCOL_NAME;
    int ind = ProtocolImpl.PROTOCOL_NAME.length;
    System.arraycopy(name ,0 ,res ,0 , ind);
    res[ind] = message.getType();
    storeInt(message.getCallId() , res , ind+1);
    storeInt(message.getBodyLength() ,res , ind+5);
    return res;
  }
  
  
  public synchronized static final int getInt(byte[] b, int off) {
    return (b[off] & INTFLAG) | ((b[off + 1] & INTFLAG) << 8) | ((b[off + 2] & INTFLAG) << 16) | ((int) b[off + 3] << 24);
  }

  public synchronized static void storeInt(int value , byte[] b , int fromIndex ) {
    b[fromIndex] = (byte)value;
    b[fromIndex+1] = (byte)(value >> 8);
    b[fromIndex+2] = (byte)(value >> 16);
    b[fromIndex+3] = (byte)(value >> 24);
  }
}