package com.inqmy.ats.system.communication.impl0;

import java.io.*;

/**
 * Class for reading and writing objects from byte[].
 * 
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public class ObjectSerializator {
  
  private  ObjectOutputStream oos;
  private ByteArrayOutputStream baos;

  private static ReferencedLoader loader;

  public ObjectSerializator() throws Exception {
   clear();
  }

  public ObjectInputStream getObjectInputStream(byte[] b)throws Exception  {
    ByteArrayInputStream bis = new ByteArrayInputStream(b);
    LocalObjectInputStream ois = new LocalObjectInputStream(bis);
    ois.setClassLoader(loader);
    return ois;
  }

  public static void setReferencedLoader(ReferencedLoader loader) {
    ObjectSerializator.loader = loader;
  }

  public byte[] serializeObject(Object obj) throws Exception  {
    ByteArrayOutputStream b = new ByteArrayOutputStream();
    ObjectOutputStream o = new ObjectOutputStream(b);
    o.writeObject(obj);
    o.flush();
    b.flush();
    byte[] res = b.toByteArray();
    o.close();
    return res;
  }

  public void clear() throws Exception {
    baos = new ByteArrayOutputStream();
    oos = new ObjectOutputStream(baos);
  }
  public byte[] getCurrentBytes() throws Exception{
    oos.flush();
    baos.flush();
    byte[] res = baos.toByteArray();
    oos.close();
    return res;

  }
  public void addObject(Object o) throws Exception {
    if(oos == null) {
      clear();
    }
    oos.writeObject(o);
  }

  public void addInt(int i) throws Exception{
    if(oos == null) {
      clear();
    }
    oos.writeInt(i);
    
  }
  public static ObjectSerializator getSerializator() throws Exception  {
    return new ObjectSerializator();
  }
}