package com.inqmy.ats.system.communication.impl0;

/**
 * Class which represents protocol coding , it contains all information about connection.
 * 
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public class Message {
  
  private int callId = 0;
  private int bodyLength = 0;
  private byte type = 0;
  private byte[] bytes;

  public Message(byte type , int callId , int bodyLength ) {
    this.bodyLength = bodyLength;
    this.callId = callId;
    this.type = type;
  }

  public int getCallId() {
    return callId;
  }
  public int getBodyLength() {
    return bodyLength;
  }
  public byte getType() {
    return type;
  }
  public void setMessageInfo(byte type  , int bodyLength) {
    this.bodyLength = bodyLength;
    this.type = type;
  }
  //protocol use this method to set different id of messages and use this object for many calls
  void setMessageId(int id) {
    callId = id;
  }
  
  void setBodyBytes(byte[] bytes) {
    this.bytes = bytes;
  }
  
  byte[] getBytes(){
    return bytes;
  }
  
  public String toString() {
    return "callId="+callId+" type="+type+" body_length="+bodyLength;
  }
}