package com.inqmy.ats.system.communication.impl0;

import com.inqmy.ats.system.communication.impl0.ReferencedLoader;

import java.io.ObjectInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;

/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public class LocalObjectInputStream extends ObjectInputStream {

  private ReferencedLoader loader;

  public void setClassLoader(ReferencedLoader loader) {
    this.loader = loader;
  }
  public LocalObjectInputStream(InputStream is) throws IOException {
    super(is);
  }
  //first try with local loader after that with thread context class loader and finally with loader of this class
  public Class resolveClass(ObjectStreamClass osc) throws IOException , ClassNotFoundException {
    Class clas = null;
    if (loader != null) {
      try {
        clas = loader.loadClass(osc.getName());
        return clas;
      } catch(ClassNotFoundException cnfexc) {
      } catch(NoClassDefFoundError ncdfe) {
      }
    }
    ClassLoader cl = Thread.currentThread().getContextClassLoader();
    if(cl != null){
      try {
        clas = cl.loadClass(osc.getName());
        return clas;
      } catch(ClassNotFoundException cnfexc) {
      } catch(NoClassDefFoundError ncdfe) {
      }
    }
    try {
      clas = Class.forName(osc.getName());
      return clas;
    } catch(ClassNotFoundException cnfexc) {
    } catch(NoClassDefFoundError ncdfe) {
    }
    return super.resolveClass(osc);
  }

}
