package com.inqmy.ats.system.communication.client;

import com.inqmy.ats.system.communication.RemoteInvokeException;
import com.inqmy.ats.system.communication.protocol.Protocol;

/**
 * Class for working with communication  
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public interface CommunicationContext {

  //this method register listener for objects that are registered in CommunicationContext
  public void registerListener(RegisterListener listener) throws RemoteInvokeException;

  //unregister registered listener
  public void unregisterListener(RegisterListener listener) throws RemoteInvokeException;

  //this method return proxy of object who is registered
  public Proxy getProxy(String name) throws RemoteInvokeException ;
  
  //this method register object for remote calls,returns proxy object for this class
  public void registerObject(String name , Object object) throws RemoteInvokeException ;

  //this method unregister object with specefied registered name
  public void unregisterObject(String name) throws RemoteInvokeException ;


  public Protocol getProtocol();

  //sets loader to load classes that are received remotely
  public void setClassLoader(ClassLoader loader);

  //retuns port of socket that is used for communication
  public int getPort();

  public String getHost();

}