package com.inqmy.ats.system.communication;

import com.inqmy.ats.system.tools.Utilities;

import java.io.PrintWriter;
import java.io.PrintStream;

/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class RemoteInvokeException extends Exception {

  private Throwable thr;
  private String stackTrace;

  public RemoteInvokeException(String message, Throwable targetException) {
    super(message);
    this.thr = targetException;
    if(thr != null) {
      stackTrace = Utilities.exceptionToString(thr);
    }
  }
  public RemoteInvokeException(String message) {
    super(message);
  }
  
  public Throwable getTargetException(){
    return thr;
  }
  
  public void printStackTrace(){
    super.printStackTrace();
    if(stackTrace != null){
      System.out.println(stackTrace);
    }
  }

  public void printStackTrace(PrintWriter pw) {
    super.printStackTrace(pw);
    if(stackTrace != null){
      pw.print(stackTrace);
    }
  }

  public void printStackTrace(PrintStream pw) {
    super.printStackTrace(pw);
    if(stackTrace != null){
      pw.print(stackTrace);
    }
  }

}