package com.inqmy.ats.system.communication;

import java.util.*;
import java.lang.reflect.*;

/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public class ObjectStore {

  private static Hashtable hash = new Hashtable();
  private static Hashtable localObjects = new Hashtable();

  public static void storeObject(String key , Object obj) {
    ObjectMethodWrapper wrapper = new ObjectMethodWrapper(obj);
    hash.put(key , wrapper);
  }
  
  public static void storeLocalObject(String key , Object obj) {
    ObjectMethodWrapper wrapper = new ObjectMethodWrapper(obj);
    localObjects.put(key , wrapper);
  }
  public static Object removeObject(String key) {
    ObjectMethodWrapper omw = (ObjectMethodWrapper) hash.remove(key);
    if(omw == null ) {
      return null;
    } else {
      return omw.getObject();
    }
  }
  public static Object removeLocalObject(String key) {
    ObjectMethodWrapper omw = (ObjectMethodWrapper) localObjects.remove(key);
    if(omw == null ) {
      return null;
    } else {
      return omw.getObject();
    }
  }
  public static com.inqmy.ats.system.communication.client.Proxy[] getAllProxies(){
    Enumeration e = hash.elements();
    Vector v = new Vector();
    while(e.hasMoreElements()) {
      v.add(((ObjectMethodWrapper)e.nextElement()).getObject());
    }
    com.inqmy.ats.system.communication.client.Proxy[] res = new com.inqmy.ats.system.communication.client.Proxy[v.size()];
    v.copyInto(res);
    return res;
  }
  public static Object getObject(String key) {
    ObjectMethodWrapper wrapper = (ObjectMethodWrapper)hash.get(key);
    if(wrapper != null){
      return wrapper.getObject();
    } 
    return null;
  }
  public static Object getLocalObject(String key) {
    ObjectMethodWrapper wrapper = (ObjectMethodWrapper)localObjects.get(key);
    if(wrapper != null){
      return wrapper.getObject();
    }
    return null;
  }

  public static Method getMethodFor( String key , int index) throws Exception {
    ObjectMethodWrapper wrapper = (ObjectMethodWrapper)hash.get(key);
    if(wrapper != null){
      return wrapper.getMethodAt(index);
    }
    throw new Exception("No such object with name : " + key);
  }
  public static Method getMethodLocalFor( String key , int index) throws Exception {
    ObjectMethodWrapper wrapper = (ObjectMethodWrapper)localObjects.get(key);
    if(wrapper != null){
      return wrapper.getMethodAt(index);
    }
    throw new Exception("No such object with name : " + key);
  }  
  //returns all public methods of class of specefied object in sort order
  public static Method[] getPublicMethodsForInvoke(Class c) {
    Vector v = new Vector();
    Method[] methods = c.getDeclaredMethods();//gets all metods in this class exclude inheritted onces
    Method m = null;
    Hashtable namesToMethods = new Hashtable();
    for (int i =0 ; i < methods.length ; i++) {
      m = methods[i];
      if (m.getModifiers() == Modifier.PUBLIC) {
        String s = m.getName();
        Class[] params = m.getParameterTypes();
        for (int y = 0 ; y < params.length ; y++) {
          s+= params[y].getName();
        }
        namesToMethods.put(s , m);
        v.add(s);
      }
    }
    methods = new Method[v.size()];
    String[] strings = new String[v.size()];
    v.toArray(strings);
    java.util.Arrays.sort(strings);
    for (int i = 0 ; i < strings.length ; i++) {
      methods[i] = (Method)namesToMethods.get(strings[i]);
    }
    return methods;
  }
  
}
class ObjectMethodWrapper {
    
  private Object object;
  private Method[] methods;
    
  public ObjectMethodWrapper(Object ob) {
    this.object = ob;
    methods = ObjectStore.getPublicMethodsForInvoke(object.getClass());
  }
    
  public Object getObject(){
    return object;
  }
  public Method getMethodAt(int index) {
    return methods[index];
  }
}

