package com.inqmy.ats.system.communication;

import com.inqmy.ats.boot.CoreClassLoader;

import java.io.*;
import java.lang.reflect.*;
import java.util.Vector;
import java.util.Hashtable;

/**
 * This class generates Proxy class generator for classes that will provide remote method calls.
 * How generator works :
 * 1 load passed class.
 * 2 takes all interfaces that class implements.
 * 3 takes all public methods from these interfaces and generate Proxy class.
 *
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public class Generator {
   
   private Class clazz;
   private File home;
   private static String sufix = "_Proxy";
   private static String classPath;
  private static File outputDir;

  public static void main(String[] rgs)throws Exception {
    try{
      if(rgs.length != 8) {
        printUsages(System.out);
        return;
      }
      int i = 0 ;
      String className = null;
      String output = null;
      String home = null;
      while(true) {
        String n = rgs[i];
        if(n.equalsIgnoreCase("-class")) {
          className = rgs[i+1].trim();
        } else if(n.equalsIgnoreCase("-classpath")) {
          classPath = rgs[i+1].trim();
        } else if(n.equalsIgnoreCase("-output")) {
          output = rgs[i+1].trim();
        } else if(n.equalsIgnoreCase("-home")) {
          home = rgs[i+1].trim();
        } else {
          printUsages(System.out);
          return;
        }
        if(i == 6) break;
        i += 2;
      }
  //    Class c = Class.forName(className);
        CoreClassLoader loader = new CoreClassLoader(Generator.class.getClassLoader() , classPath);
        Class c = loader.loadClass(className);
      outputDir = new File(output).getCanonicalFile();
      if(!outputDir.exists()) {
        outputDir.mkdirs();
      }
      File f = new File(home);
System.out.println("CLASSPATH = " +classPath);
System.out.println("HOME = " +f.getCanonicalPath());
System.out.println("CLASS = " +c.getName());
System.out.println(outputDir.exists() + "OUTPUT = " +outputDir.getCanonicalPath());
      Generator g = new Generator(c , f , sufix);
      g.generate();
    } catch(Throwable t) {
      t.printStackTrace();
    }
  }

  private static void printUsages(PrintStream ps) throws Exception {
    ps.println("Usage : ");
    ps.println("generate [-class] <class_name> [-classpath] <class_path> [-output] <directory_path> [-home] <directory_path>");
    ps.println("Parameters : ");
    ps.println("\t [-class] : Specifies class for which will be generated Proxy for communication.");
    ps.println("\t        <class_name> -> full class name");

    ps.println("\t [-classpath] : Specifies class path.");
    ps.println("\t        <class_path>      -> calss path.");

    ps.println("\t [-output] : Where to put generated class.");
    ps.println("\t        <directory_path>  -> Output directory.");

    ps.println("\t [-home] : Where to find class.");
    ps.println("\t        <directory_path>  -> Class file home package directory.");

  }

  private Generator(Class c , File home , String sufix) {
    this.clazz = c;
    this.home = home;
    this.sufix = sufix;
  }
  
  private void generate() throws Exception {
    String className = clazz.getName();
    String fileName = null;
    String pack = null;
    if(className.indexOf(".") != -1) {
      pack = className.substring(0 , className.lastIndexOf("."));
      fileName = className.replace('.' , File.separatorChar) + sufix;
      File f = new File(outputDir , pack.replace('.', File.separatorChar));
      f.mkdirs();
    } else {
      fileName = className + sufix;
    }
    File resultFile = new File(outputDir + File.separator + fileName + ".java");
    String forCompile = fileName + ".java";
    FileOutputStream out = new FileOutputStream(resultFile);
    if(pack != null){
      out.write(("package " + pack +";\r\n").getBytes());
    }
    out.write(("import com.inqmy.ats.system.communication.client.CommunicationContextImpl;\r\n" ).getBytes());
    out.write(("import com.inqmy.ats.system.communication.client.Proxy;\r\n" ).getBytes());
    out.write(("import com.inqmy.ats.system.communication.RemoteInvokeException;\r\n" ).getBytes());
    out.write(("import com.inqmy.ats.system.CoreContext;\r\n" ).getBytes());
Class[] interf = clazz.getInterfaces();
String interfase = null;

if(interf.length != 0){
  interfase = "";
  for(int ii = 0 ; ii < interf.length ; ii++){
    interfase += interf[ii].getName() + (ii == (interf.length - 1) ? "" : ",");
    out.write(("import " +interf[ii].getName() + ";\r\n" ).getBytes());
  }
} else {
    System.out.println("No interfaces!Exiting");
    return;
}
    out.write(("public class " + new File(home , fileName).getName() +" extends Proxy "+(interfase == null  ? "" :(" implements "+ interfase))+"{\r\n" ).getBytes());
//    out.write(("\tpublic static final Communication communication = Communication.getInstance();\r\n\n").getBytes());
    //Method[] methods = ObjectStore.getPublicMethodsForInvoke(clazz);
      Method[] methods =  getPublicMethodsForInvoke(interf);

    Method m = null;
    for (int i = 0 ; i < methods.length ;i++ ) {
      m = methods[i];
      Class[] params = m.getParameterTypes();
      String[] parametersClassNames = getClassNames(params);
      Class returnType = m.getReturnType();
      String returnTypeName =  getTypeName(returnType);
      out.write(("\tpublic " + returnTypeName + " " + m.getName()+"(").getBytes());
      String forClassNames = "";
      String forParams = "";
      String classNames = "";
      String paramsNames = "";
      for (int p = 0 ; p < parametersClassNames.length ;p++ ) {
        paramsNames+= ("param_"+ p + ((p == parametersClassNames.length -1) ? "" : ",") );
        out.write((" " + parametersClassNames[p] +" param_"+p + ((p == parametersClassNames.length -1) ? " " : ",")).getBytes());
        forClassNames += "\"" + parametersClassNames[p] +"\""+ ((p == parametersClassNames.length -1) ? "" : ",");
        classNames+= parametersClassNames[p] +".class" + ((p == parametersClassNames.length -1) ? "" : ",");          
        forParams += getObjectNameFor(parametersClassNames[p] , ("param_"+ p)) + ((p == parametersClassNames.length -1) ? "" : ",");
      }
      out.write((") throws RemoteInvokeException { \r\n").getBytes());

      //out.write(("Class[] classNames ="+ (classNames.equals("") ? "null;\r\n" : (" new Class[]{" +classNames+ "};\r\n"))).getBytes());
      out.write(("\t\tObject targetObject = super.getTargetObject();\r\n").getBytes());
      out.write("\t\tObject result = null;\r\n".getBytes());
      out.write(("\t\tif(targetObject != null) {\r\n").getBytes());
      if(returnType.getName().equals("void")){
        out.write(("\t\t\t" + getObjectNameFor(returnTypeName , ("(("+className + ")targetObject)."+m.getName()+"("+paramsNames+")"))+";\r\n").getBytes());
      }else{
        out.write(("\t\t\tresult = " + getObjectNameFor(returnTypeName , ("(("+className + ")targetObject)."+m.getName()+"("+paramsNames+")"))+";\r\n").getBytes());
      }
      out.write(("\t\t} else {\r\n").getBytes());
      out.write(("\t\t\tint methodIndex ="+ i +";\r\n").getBytes());      
      out.write(("\t\t\tObject[] params ="+(forClassNames.equals("") ? "null;\r\n" : ( "new Object[]{" +forParams+ "};\r\n"))).getBytes());
      out.write(("\t\t\tresult = ((CommunicationContextImpl)(CoreContext.getCommunicationContext())).invokeMethod( super.getObjectRegisteredName() ,methodIndex,params,getConnectionId());\r\n").getBytes());
      out.write("\t\t}\r\n".getBytes());
      if(!(returnType.getName()).equals("void")) {
        out.write(("\t\treturn "+getReturnStatementFor(returnTypeName,"result")+";").getBytes());
      }
      out.write(("\r\n}\r\n").getBytes());

    }
    out.write(("\r\n\t\t}" ).getBytes());
    out.close();
    compile(forCompile);
  }
  private void compile(String java) throws Exception {
    String[] cmd = new String[]{"javac" , "-classpath" , classPath+File.pathSeparator+outputDir.getCanonicalPath() , java};
    Process p = Runtime.getRuntime().exec(cmd , null , outputDir);
    p.waitFor();
  }
  private String[] getClassNames(Class[] classes) {
    String[] res = new String[classes.length];
    for (int i = 0; i < classes.length ;i++ ) {
      if(classes[i].isArray()) {
        Class compType = classes[i].getComponentType();
        String cName = compType.getName();
        String brackets = "[]";
        while(compType.isArray()) {
          brackets +="[]";
          compType = compType.getComponentType();
          cName = compType.getName();
        }
        res[i] = cName + brackets;
      } else {
        res[i] = classes[i].getName();
      }
    }
    return res;
  }

  private static Method[] getPublicMethodsForInvoke(Class[] c) {
    Vector v = new Vector();
    Method[] methods = null;
    Method m = null;
    Hashtable namesToMethods = new Hashtable();
    for (int ii = 0 ; ii < c.length ; ii++) {
      methods = c[ii].getMethods();
      for (int i =0 ; i < methods.length ; i++) {
        m = methods[i];
          String s = m.getName();
          Class[] params = m.getParameterTypes();
          for (int y = 0 ; y < params.length ; y++) {
            s+= params[y].getName();
          }
          namesToMethods.put(s , m);
          v.add(s);
      }
    }
    methods = new Method[v.size()];
    String[] strings = new String[v.size()];
    v.toArray(strings);
    java.util.Arrays.sort(strings);
    for (int i = 0 ; i < strings.length ; i++) {
      methods[i] = (Method)namesToMethods.get(strings[i]);
    }
    return methods;
  }
  private String  getObjectNameFor(String name  ,String param) {
    if(name.equals("char")) {
      return "new Character("+param+")";
    } else if(name.equals("int")) {
      return "new Integer("+param+")";
    } else if(name.equals("boolean")) {
      return "new Boolean("+param+")";
    } else if(name.equals("long")) {
      return "new Long("+param+")";
    } else if(name.equals("short")) {
      return "new Short("+param+")";
    } else if(name.equals("byte")) {
      return "new Byte("+param+")";
    } else if(name.equals("float")) {
      return "new Float("+param+")";
    } else if(name.equals("double")) {
      return "new Double("+param+")";
    }
    return param;
  }

  private String  getReturnStatementFor(String name  ,String param) {
    if(name.equals("char")) {
      return "new Character("+param+")";
    } else if(name.equals("int")) {
      return "((Integer)"+param+").intValue()";
    } else if(name.equals("boolean")) {
      return "((Boolean)"+param+").booleanValue()";
    } else if(name.equals("long")) {
      return "((Long)"+param+").longValue()";
    } else if(name.equals("short")) {
      return "((Short)"+param+").shortValue()";
    } else if(name.equals("byte")) {
      return "((Byte)"+param+").byteValue()";
    } else if(name.equals("float")) {
      return "((Float)"+param+").floatValue()";
    } else if(name.equals("double")) {
      return "((Double)"+param+").doubleValue()";
    }
    return ("("+name+")"+param);
  }
  
  private String getTypeName(Class c) {
    String name = null;
    boolean isArray = c.isArray();
    if(isArray) {
      Class compType = c.getComponentType();
      String cName = compType.getName();
      String brackets = "[]";
      while(compType.isArray()) {
        brackets +="[]";
        compType = compType.getComponentType();
        cName = compType.getName();
      }
      name = cName + brackets;
    } else {
      name = c.getName();
     }
    return name;
  }

}