package com.inqmy.ats.system.communication;

import java.net.*;
import com.inqmy.ats.system.communication.client.CommunicationContext;
import com.inqmy.ats.system.tools.CommonLog;
import com.inqmy.ats.boot.Utility;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 *
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class ConnectionManager implements Runnable {

  private boolean isServer;
  private int port;
  private String host;
  private Connection connection;
  private CommunicationContext context;
  private final int DEFAULT_COUNT = 1;

  private ServerSocket ss;

  private static Location location = Location.getLocation(ConnectionManager.class);

  private Connection[] connections;
  private int[] freeIds;
  private int freeCount = DEFAULT_COUNT;

  public ConnectionManager(boolean isServer , int port , String host , CommunicationContext context) throws Exception {
    this.isServer = isServer;
    this.port = port;
    this.context = context;
    if(!isServer) {
      this.host = host;
    } else {
      this.host = "localhost";
      connections = new Connection[DEFAULT_COUNT];
      freeIds = new int[DEFAULT_COUNT];
      for(int i = 0 ; i < DEFAULT_COUNT ; i++){
        freeIds[i] = i;
      }
      initServer();
    }
  }

  public String getHost(){
    return host;
  }
  private void init() throws Exception {
    Socket s = new Socket(host , port);
    connection = new Connection(s ,  s.getInputStream() , s.getOutputStream());
    connection.setId(0);
    connection.setProtocolHandler(context.getProtocol());
    new Thread(connection).start();
  }

  private void initServer() throws Exception {

      try {
        ss = new ServerSocket(port);
      } catch(Exception exc) {
        System.out.println("ATS cannot open server socket on port : " + port + ". Will try to open socket on different port!");
        try {
          ss = new ServerSocket(0);
          port = ss.getLocalPort();
          System.out.println("ATS have opened socket on port : " + port);
        } catch(Exception e) {
          e.printStackTrace();
          System.out.println("ATS cannot open server socket on port : " + port + ". Please change the port in file ATS/bin/system.properties. Key -> communication.server.port");
          System.out.println("ATS exist EMERGENCY!");
          System.exit(888);
        }
      }
    new Thread(this).start();
  }

  public int getPort() {
    return port;
  }
  public void run() {
    try {

      while(true){
        Socket s = ss.accept();
        connection = new Connection(s , s.getInputStream() , s.getOutputStream());
        addConnection(connection);
        location.debugT("[Connection Manager] new connection accepted.Connection id : " + connection.getId() );
        connection.setProtocolHandler(context.getProtocol());
        new Thread(connection).start();
      }
    } catch(Exception exc) {
      location.errorT("Error create server socket! Error : " + exc.getMessage());
      location.traceThrowableT(Severity.ERROR , "" , exc);
      exc.printStackTrace();
    }
  }

  private void addConnection(Connection con) {
    if(freeCount == 0) {
      int length = connections.length;
      Connection[] connects = new Connection[2*length];//new array
      System.arraycopy(connections,0,connects,0,length);
      connections = connects;
      connections[length] = con;
      con.setId(length);
      freeCount = length -1;
      freeIds = new int[2*length];
      for(int i = 1 ; i < length ; i++) {
        freeIds[i-1] = length+i;
      }
    } else {
      --freeCount;
      int conId = freeIds[freeCount];
      connections[conId] = con;
      con.setId(conId);
    }
  }

  public Connection getConnection(int id) {
    if(!isServer && connection == null) {
      try{
        init();
        return connection;
      } catch(Exception exc) {
        throw new RuntimeException("Can not connect to server!" + exc.getMessage());
      }
    }
    if(!isServer){
      return connection;
    } else {
      Connection c = null;
      try {
        c = connections[id];
      } catch(Exception exc){
        throw new RuntimeException("No connection with such id!");
      }
      return c;
    }
  }
  //invoke if problems with connection occures
  public void unregisterConnection(Connection con) {
    if(freeIds != null){
      location.debugT("[Connection Manager] Unregister connection with id : " + con.getId() + " free index ina array : " + freeCount + " free ids array length : " + freeIds.length);
      freeIds[freeCount] = con.getId();
      ++freeCount;
    }
  }
}