package com.inqmy.ats.system;

import com.inqmy.ats.system.tools.PropertiesManager;
import com.inqmy.ats.system.communication.RemoteInvokeException;

import java.io.Serializable;

/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public interface RuntimeControlInterface {
  
  //provider start logic
  public void start()throws RemoteInvokeException;
  
  //provider stop logic
  public void stop()throws RemoteInvokeException;
  
  //returns serializable object with current setting environment of provider 
  public Serializable getSettingEnvironment()throws RemoteInvokeException;
  
  //called to initialize provider with specefied setting environment
  public void setSettingEnvironment(Object environment)throws RemoteInvokeException;

  //returns provider additional name 
  //used for system log
  public String getProviderName()throws RemoteInvokeException;
    
  
}
