package com.inqmy.ats.system;

import javax.swing.*;
import java.awt.*;

/**
 * Test provider have to implement this interface for visual administration  
 * implementation of this interface must have empty constructor
 * 
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public interface GUIRuntimeControlInterface {
  
  //set main frame where will be displyed
  public void setGUIContainer(JFrame frame);
  
  //control - the runtimeControl interface of provider
  //this method is called every time when visualization of provider is required
  public void setControl(RuntimeControlInterface control) throws Exception;
  
  //return visual implementation
  public JComponent getGUIControlComponent();
  
  public void setSettingEnvironment(java.io.Serializable settings);
  public java.io.Serializable getSettingEnvironment();
  
  public JButton[] getButtons();
  //called to make clean-up , and release any referenced resources.
  public void free();
  
}
