package com.inqmy.ats.system;

import com.inqmy.ats.system.communication.RemoteInvokeException;
import com.inqmy.ats.system.tools.LogListener;
import com.inqmy.ats.system.tools.CommonLog;

/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public class EngineControlImpl implements EngineControl {
  private Engine engine;
  public EngineControlImpl(Engine engine) {
    this.engine = engine;
  }
  
  public String getCUIClassName(String providerAdditionalName) throws RemoteInvokeException {
    return engine.getGUIInterfaceClassName(providerAdditionalName);
  }
  public String getImplClassName(String additName) {
    return engine.getProvider(additName).getClass().getName();
  }

  public void addLogListener(LogListener listener) throws RemoteInvokeException {
    CommonLog.setLogListener(listener);
  }
  public RuntimeControlInterface getProviderRuntimeControl(String providerAdditionalName) throws RemoteInvokeException {
    return engine.getProviderRuntimeControl(providerAdditionalName);
  }

  public String[] getAllProviderNames() throws RemoteInvokeException {
    return engine.getProviderNames();
  }

}
