package com.inqmy.ats.gui.tools;

import java.io.*;
import javax.swing.*;

public class VisualOutputStream extends OutputStream {

  private JTextArea area;
  private StringBuffer buffer;
  private boolean toFlush = false;
  private boolean autoScroll = false;
  private JScrollBar sb;

  public VisualOutputStream(JTextArea area) {
    this.area = area;
    buffer = new StringBuffer(1024);
  }

  public VisualOutputStream(JTextArea area , JScrollBar sb, boolean autoFlush) {
    this.area = area;
    this.sb = sb;
    this.toFlush = autoFlush;
    buffer = new StringBuffer(1024);
  }

  public synchronized void write(byte[] s) {
    buffer.append(new String(s));
    if(toFlush) {
      flush();
    }

  }

  public synchronized void write(byte[] s, int off, int len) {
    buffer.append(new String(s, off, len));
    if(toFlush) {
      flush();
    }
    if(autoScroll) {
      area.setCaretPosition(area.getText().length());
      sb.setValue(sb.getMaximum());
    }
  }

  public synchronized void write(int s) {
    buffer.append((byte)s);
    if(toFlush) {
      flush();
    }
    if(autoScroll) {
      area.setCaretPosition(area.getText().length());
      sb.setValue(sb.getMaximum());
    }
  }

  public synchronized void flush() {
    area.append(buffer.toString());
    buffer.delete(0 , buffer.length());
  }

  public void setAutoScroll(boolean autoScroll) {
    this.autoScroll = autoScroll;
  }
}