package com.inqmy.ats.gui.tools;

import javax.swing.*;
import java.awt.*;

/**
 * This class is used to show message dialog in new thread.
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class MessageUtil {
   //TODO  make a thread pool!!!!

  public static int ERROR_MESSAGE = JOptionPane.ERROR_MESSAGE;
  public static int INFORMATION_MESSAGE = JOptionPane.INFORMATION_MESSAGE;

  public static void showDialog(String message , Component parent , int type , String title) {
    new Thread(new MessageThread(message , parent , type , title)).start();
  }
}

class MessageThread implements Runnable {
  private String message;
  private String title;
  private Component parent;
  private int type;
  MessageThread(String message, Component parent, int type , String title) {
    this.message = message;
    this.title = title;
    this.parent = parent;
    this.type = type;
  }

  void setMessage(String message , Component parent, int type) {
    this.message = message;
    this.parent = parent;
    this.type = type;
  }

  public void run() {
    JOptionPane.showMessageDialog(parent , message , title , type);
  }
}
