package com.inqmy.ats.gui.tools;

import java.io.*;

public class LoadingStream extends InputStream {
  
  private long limit = -1;
  private long count = 0;
  private LoadingListener listener;
  private InputStream sourceStream;
  private boolean flag = false;

  public LoadingStream(InputStream stream, long limit , LoadingListener listener) {
    sourceStream = stream;
    this.limit = limit;
    this.listener = listener;
  }

  public int read(byte[] b) throws IOException {
    if (flag) {
      listener.overLoaded();
      count = 0;
      flag = false;
      return -1;
    }
    int readed = sourceStream.read(b);
    if(readed == -1) {
      listener.finish();
      return -1;
    }
    count+= readed;
    if (count > limit) {//limit over-loaded
      flag = true;
    }
    return readed;
  }
 
  public int read(byte[] s, int off, int len) throws IOException {
    if (flag) {
      listener.overLoaded();
      count = 0;
      flag = false;
      return -1;
    }
    int readed = sourceStream.read(s, off, len);
    if(readed == -1){
      listener.finish();
      return -1;
    }
    count+= readed;
    if (count > limit) {//limit over-loaded
      flag = true;
    }
    return readed;
  }
  
  public int read() throws IOException {
    if (flag) {
      listener.overLoaded();
      count = 0;
      flag = false;
      return -1;
    }
    int readed = sourceStream.read();
    if(readed == -1){
      listener.finish();
      return -1;
    }
    ++count;
    if (count > limit) {//limit over-loaded
       flag = true;
    }
    return readed;
  }
}